# -*- coding: Latin1 -*-  
#
## alternativ: -*- coding: utf-8 -*-
# File: tkSimpleText.py
# vgl. auch tkSimpleDialog.py von F. Lundh 
# siehe F. Lundh: An Introduction to Tkinter, ch. 9: Dialog Windows 
# http://www.pythonware.com/library/tkinter/introduction/index.htm 
# Vers. 0.15, Date: 2008-02-23
# Text Widget is NOT resizable!!

from Tkinter import *
from ScrolledText import *
import os

## font and font-size
## courier_pitch == 1  unter posix und XFree86 >= 4.3
courier_pitch = 0
if courier_pitch:
    gf_font_art='normal'
    gf_font_type='courier 10 pitch'
else:
    gf_font_art='bold'
    gf_font_type='courier'
    
if os.name == 'posix':
    gf_font_size=12
else:    
    ##gf_font_type='systemfixed'    
    gf_font_size=10
gf_font=(gf_font_type,gf_font_size,gf_font_art)    


class Text(Toplevel):

    def __init__(self, parent, title = None, button_message = None,TEXT=None, x_dim = None, y_dim = None, state=None ):

        Toplevel.__init__(self, parent)
        ## Mit dem folgenden Befehl liegt das Fenster
        ## immer ber dem parent-Fenster
        ## self.transient(parent)

        if title:
            self.title(title)
            self.mytitle = title
            

        
        self.parent = parent

        self.Text = TEXT
        
        # size of window
        if not x_dim:   
            self.width = 80
        else:    
            self.width = x_dim
            
        if not y_dim:
            self.height = 33
        else:    
            self.height = y_dim
            
        if state:
            self.state = state
        else:
            self.state = NORMAL
            
        
        self.initial_focus = self.body() #

                
        if not button_message:        
            self.close_message = "Quit"   
        else:
            self.close_message = button_message
            
        self.buttonbox()
        
            
        ## Der folgende Befehl verhindert, dass der
        ## Focus auf ein anderes Fenster gesetzt werden kann 
        ##self.grab_set()

        if not self.initial_focus:
            self.initial_focus = self

        self.protocol("WM_DELETE_WINDOW", self.die)

        self.geometry("+%d+%d" % (parent.winfo_rootx()+50,
                                  parent.winfo_rooty()+50))

        self.initial_focus.focus_set()
	
	self.resizable('0','0')  # window should NOT be resizable!

        self.wait_window(self)

    #
    # construction hooks

    def body(self):
        # create dialog body. 
        _body_ = Frame(self)

        t = ScrolledText(_body_,width=self.width,height=self.height,relief=RAISED,font=gf_font,bd=2,background="white",foreground="navy",wrap=WORD)
        t.config(state=NORMAL)  # see http://effbot.org/zone/tkinter-text.htm
        t.insert(END,self.Text)        
        t.pack(fill=BOTH, expand=1)  ## important
        t.config(state = self.state)        
        _body_.pack(fill=BOTH, expand=1)
    

    def buttonbox(self):
        # add standard button box. override if you don't want the
        # standard buttons
        
        box = Frame(self)

        w = Button(box, text= self.close_message, width=20, command=self.ok, default=ACTIVE)
        w.pack(side=LEFT, expand=1)

        self.bind("<Return>", self.ok)

        box.pack( fill=BOTH, expand=0)

    #
    # standard button semantics

    def ok(self, event=None):

        if not self.validate():
            self.initial_focus.focus_set() # put focus back
            return

        self.withdraw()
        self.update_idletasks()

        #self.apply()
        
        self.die()
        

    def die(self, event=None):
        # put focus back to the parent window
        self.parent.focus_set()
        self.destroy()
        
    #
    # command hooks
    

    def validate(self):

        return 1 # override

    def apply(self):

        pass # override

    
