# -*- coding: Latin1 -*-  
#
## alternativ: -*- coding: utf-8 -*-
# File: tkScrollbox.py
# vgl. auch tkSimpleDialog.py von F. Lundh 
# siehe F. Lundh: An Introduction to Tkinter, ch. 9: Dialog Windows 
# http://www.pythonware.com/library/tkinter/introduction/index.htm 
# IN: title, tab_list, button_message, cancelMessage, Cancel_button, x_dim, y_dim
# Retour: self.result (of type INT) (gewhltes Listenelement)
# Vers. 0.2, Date: 2004-01-20
# Vers. 0.3, Date: 2006-05-10 (Bug wg primary key beseitigt, siehe Methode get_column)
# Vers. 0.4, Date: 2006-05-30 (Bug wg foreign key beseitigt, siehe Methode get_column)
# beachte aber: FOREIGN KEY constraints FOREIGN KEY constraints are parsed but are not enforced.
# URL: http://www.sqlite.org/omitted.html

from Tkinter import *
import os

class Scrollbox(Toplevel):
    
    def __init__(self, parent, title = None, tab_list = None, button_message=None, cancelMessage=None, Cancel_button=None, x_dim = None, y_dim = None, gfInt = None, scroll_settings = None ):
        """Aufruf: Scrollbox(root,title='TITEL',tab_list=['drei','viervierviervier','fnf'])"""
        
        Toplevel.__init__(self, parent)
        ## Mit dem folgenden Befehl liegt das Fenster
        ## immer ber dem parent-Fenster und
        ## kann nicht verkleinert/vergrert werden
        self.transient(parent)

        if title:
            self.title(title)
            self.mytitle = title
            
        self.parent = parent

        self.gfInter = gfInt

        self.settings = scroll_settings
        # size of scrollbox
        if not x_dim:   
            self.width = 20
        else:    
            self.width = x_dim
            
        if not y_dim:
            self.height = 5
        else:    
            self.height = y_dim
            
        self.result = None

        self.listbox = None        

        body = Frame(self)
        self.initial_focus = self.body(body)
        #body.pack(padx=5, pady=5)
        body.pack(expand=NO)
        
        
        if not tab_list:        
            self.element_liste = [' ',' ','No Tables created . . .']  # alternativ: []
        else:
            self.element_liste = tab_list           

        
        if not self.button_message:        
            self.box_message = "Ok"   
        else:
            self.box_message = self.button_message

##        self.cancel_message = "Cancel"
        if not self.cancelMessage:        
            self.cancel_message = "Cancel"            
        else:
            self.cancel_message = self.cancelMessage
    
        self.Cancel = 1
        if not Cancel_button:
            if (Cancel_button == 0):
                self.Cancel = 0
                
        if not self.Cancel:
            self.bind("<Button-3>",self.popup)
            ##self.bind("<Button-3>",self.test_print)
            self.box_menu = Menu(body,tearoff=0)
            self.columnMenu = Menu(self.box_menu,tearoff=0)
            self.box_menu.add_command(label=self.settings.get('tk_copy'), command=self.box_copy  )      
            self.box_menu.add_separator()
            ##self.box_menu.add_command(label=('Spalten'), command=self.get_column  )                  
            self.box_menu.add_cascade(label=self.settings.get('small_column'),  menu=self.columnMenu)
            self.old_list_len = 0
            
        self.listbox = self.scrollbox()             
          

        ## Der folgende Befehl verhindert, dass der
        ## Focus auf ein anderes Fenster gesetzt werden kann 
        #self.grab_set()

        if not self.initial_focus:
            self.initial_focus = self

        self.protocol("WM_DELETE_WINDOW", self.die)

        self.geometry("+%d+%d" % (parent.winfo_rootx()+50,
                                  parent.winfo_rooty()+50))

        self.initial_focus.focus_set()

        self.wait_window(self)

    #
    # construction hooks

    def body(self, master):
        # create scrollbox body.  return widget that should have
        # initial focus.  this method should be overridden

        pass

    def scrollbox(self):
        # my first scrollbox. override if you don't want the
        # standard scrollbox
        
        box = Frame(self)
        buttonBox = Frame(self)
        okbutton = Button(buttonBox,text=self.box_message,command=self.returnSelection )
        if self.Cancel:
            cancelbutton = Button(buttonBox,text=self.cancel_message,command=self.die )

        
        vscroll = Scrollbar(box, orient=VERTICAL)
        ##hscroll = Scrollbar(box, orient=HORIZONTAL)

        listbox = Listbox(box,width=self.width,height=self.height, selectmode=BROWSE, background="white")
                
        listbox.configure(yscrollcommand=vscroll.set)
        ##listbox.configure(xscrollcommand=hscroll.set)
        for name in self.element_liste:
            listbox.insert(END,name)
            
        vscroll.config(command=listbox.yview)    
        ##hscroll.config(command=listbox.xview)
        
        if self.Cancel:
            okbutton.pack(side=LEFT,fill=BOTH,expand=YES)
            cancelbutton.pack(side=RIGHT,fill=BOTH,expand=YES)
        else:
            okbutton.pack(fill=BOTH,expand=YES)
        
        ##hscroll.pack(side=BOTTOM,fill=X)
        listbox.selection_set(0) ## ersetn Eintrag markieren
        
        listbox.pack(side=LEFT, expand=YES, fill=BOTH)

        

        
        vscroll.pack(side=LEFT,fill=Y)

        self.bind("<Return>", self.returnSelection)
        self.bind("<Escape>", self.die) 

        box.pack( fill=BOTH, expand=NO)
                
        buttonBox.pack(fill=BOTH, expand=NO)
        
        return listbox

    def test_print(self):
        print ". . . Dummy-Print-Befehl . . ."

    def get_column(self):
        """benoetigt gfInter und settings-Objekt"""
        import string
        _debug_ = 1
        if _debug_:
            print "here get_column . . ."
        liste = []
        self.box_menu.update_idletasks() 
        auswahl =  self.listbox.curselection()
        if _debug_:        
            print auswahl[0]
        try:
            wert = getint(auswahl[0])
            marked_text = self.element_liste[wert]
            if _debug_:            
                 print "Spalte: " + marked_text
            SERVER = 0
            table = marked_text
            ergebnis = self.gfInter.gfdesc( SERVER, table,self.settings.get('table'),self.settings.get('tab_column') )
##            if _debug_:
##                print str(ergebnis)
            liste = string.split(ergebnis)
            index = 0
            i = 0
            for element in liste:   # Kopf entfernen
                if string.find(element,'==') != -1:
                    index = i 
                i = i + 1
            neuliste = liste[index+1:]
            liste = []
            for element in neuliste:    # kombinierter Primary Key ist keine Spalte
                if (string.find(string.lower(element),'primary') == -1) and (string.find(string.lower(element),')') == -1):
                    if (string.find(string.lower(element),'foreign') == -1):  # foreign key ist keine Spalte                  
                        if (string.find(string.lower(element),'(') != -1):
                            neu = element[1:]   # ohne '('
                            liste.append(neu)   # liste aufbauen!
                        else:
                            liste.append(element)   # liste aufbauen
            if _debug_:            
                for element in liste:
                    print element
            return liste                
        except:
            ##print "Pech gehabt . . ."
            return liste    

    def dummy_func(self,col):
##        print col
        pass

    def box_copy(self):
        """Das funktioniert!"""
        auswahl =  self.listbox.curselection() 
        #print auswahl[0]
        wert = getint(auswahl[0])
        marked_text = self.element_liste[wert]
        self.clipboard_clear()
        self.clipboard_append(marked_text)


    def popup(self, event):
        liste = self.get_column()
        if liste > 0:
            ##self.columnMenu.delete(0) # loescht einen Eintrag
            try:
                self.columnMenu.delete(0, self.old_list_len)
            except:
                pass
            self.old_list_len = len(liste)  # neu setzen!
            for i in range(len(liste)):                
                argument =  liste[i]
                self.columnMenu.add_command(label=argument, command=(lambda arg=argument,s=self : s.dummy_func(arg) ) )        
        self.box_menu.post(event.x_root, event.y_root)

                    
    def returnSelection(self, event=None):
        auswahl =  self.listbox.curselection() 
        #print auswahl[0]
        try:
            wert = getint(auswahl[0])
            #print wert
            #print "Gewaehlt: " + self.element_liste[wert]
            self.result = wert
        except IndexError:
            self.result = None
        self.withdraw()
        self.update_idletasks()

        self.apply()
        
        self.die()


    #
    # standard button semantics

    def ok(self, event=None):

        if not self.validate():
            self.initial_focus.focus_set() # put focus back
            return

        self.withdraw()
        self.update_idletasks()

        #self.apply()
        
        self.die()

        

    def die(self, event=None):
        # put focus back to the parent window
        self.parent.focus_set()
        self.destroy()
        
    #
    # command hooks
    

    def validate(self):

        return 1 # override

    def apply(self):

        pass # override

    
