# -*- coding: Latin1 -*-  
#
## alternativ: -*- coding: utf-8 -*-
"""
    html_tools.py: HTML-Untersttzung, W.S.,
    Vers. 0.05, 2005-01-06, mit DOCStrings!
    Vers. 0.04: ucodefilter_, eingebaut in table_heading und table_body
    Vers. 0.05: Optimierung mittels Liste in table_body
    nach Python in a Nutshell, p. 400
    Vers. 0.06: ucodefilter_ erweitert, 2006-05-24     
"""

import umlautCodec
codes = umlautCodec.htmlCodes

def titel_(titel):
    "erzeugt den Titel einer HTML-Datei"
    titel_tag = '\n<title>' + titel + '</title>\n'
    return titel_tag


def head_ (titel,producer=""):
    "erzeugt den Kopf einer HTML-Datei"
    import time
    meta = '\n<!-- generated by ' + producer + ', ' +  time.strftime("%A %B %d, %Y %I:%M %p",time.localtime(time.time())) + ' -->\n'
    meta = meta + '<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">\n'    
    kopf = '\n<head>' + meta +  titel_(titel) + '</head>\n'
    return kopf


def body_ (text,textfarbe,bgfarbe):
    "erzeugt den Rumpf einer HTML-Datei, Aufruf: text = body_(text,textfarbe,bgfarbe)"    
    rumpf = '<body text="' + textfarbe + '" bgcolor="' +  bgfarbe +'">\n'
    rumpf = rumpf + font_(text) + '\n</body>'
    return rumpf

def font_ (inhalt,font_style="arial,helvetica"):
    "versieht <inhalt> mit dem font in font_style"    
    text = '<font face="' + font_style +  '">\n'
    text = text + inhalt + '\n</font>'
    return text
 
def html_ (titel,text,textfarbe,bgfarbe,generated_by=''):
    "erzeugt eine HTML-Datei, Aufruf: htmltext = html_('Titel',text,textfarbe,bgfarbe)"
    html = '<html>' + head_(titel,producer=generated_by) 
    html = html + body_( text,textfarbe,bgfarbe )
    html = html + '\n</html>'
    return html

##def filter_(zeile,debug=0):
##    "kodiert Sonderzeichen in HTML"
##    # die Sonderzeichen werden im Dictionary 'codes' festgelegt    
##    codes = {'�:'&auml;','�:'&Auml;','�:'&ouml;','�:'&Ouml;','':'&uuml;','�:'&Uuml;','�:'&szlig;','<':'&lt;','>':'&gt;','&':'&amp;','"':'&quot;'}    
##    text = ''
##    for i in range( len(zeile) ):
##        if debug:
##            print zeile[i]
##        if codes.has_key(zeile[i]):
##            text = text + codes[zeile[i]]
##        else:
##            text = text + zeile[i]
##        if debug:
##            print text,    
##    return text

def ucodefilter_(zeile,debug=0):
    "kodiert Unicode-Sonderzeichen in HTML"
    # die Sonderzeichen werden im Dictionary 'codes' festgelegt    
    text = ''
    zeile = zeile.encode('latin-1')
    for i in range( len(zeile) ):
        if debug:
            print zeile[i]
        if codes.has_key(zeile[i]):
            text = text + codes[zeile[i]]
        else:
            text = text + zeile[i]
        if debug:
            print text,    
    return text

def b_(text):
    "Bold = fett"    
    return '<b>' + text + '</b>'

def i_(text):
    "Italic = kursiv"
    return '<i>' + text + '</i>'

def u_(text):
    "underline = unterstrichen"
    return '<u>' + text + '</u>'

def p_(text):
    "Paragraph"
    return '<p>\n' + text + '</p>\n'

def br_(text,anzahl=0):
    "gibt anzahl breaks (new lines) aus"
    if anzahl == 0:
        return text + '<br>'
    else:
        return text + '<br>'*anzahl

def pre_(text):
    "PREformatted text"
    return '<pre>' + text + '</pre>\n'

def table_(inhalt, rand=1, align="center"):
    "gibt 'inhalt' als Tabelle zurck"
    tabelle = '<table border="' + str(rand) + '" align="' + align +'" summary >\n'
    tabelle = tabelle + inhalt + '\n</table>'
    return tabelle
    
def table_heading(liste,_filter_=0):
    "erzeugt die erste Zeile = Kopf der Tabelle aus der <liste>"
    weite = len(liste)
    if weite > 0:
        head = '<tr>\n'
        for i in range(weite):
            if _filter_:    # use unicocde-filter
                head = head + '<th>' + ucodefilter_( str(liste[i]) )  + '</th>\n'
            else:    
                head = head + '<th>' + str(liste[i])  + '</th>\n'
        head = head + '</tr>\n'
    return head
    
def table_body(liste,weite,_filter_=0):
    """erzeugt die restliche Tabelle aus der <liste>
    Optimierung mittels Liste nach Python in a Nutshell, p. 400
    """    
    body = ''
    body_list = []
    if weite > 0:
        for zeile in liste:
            body_list.append('<tr>\n')
            for elements in zeile:         
                if len(str(elements)) < 1:  ## elements leer!
                    elements = '&nbsp;'
                if _filter_:    # use unicocde-filter
                    body_list.append('<td>')
                    body_list.append( ucodefilter_( str(elements) ) )
                    body_list.append('</td>\n')
                else:
                    body_list.append('<td>')
                    body_list.append( str(elements) )
                    body_list.append('</td>\n')
            body_list.append('</tr>\n')        
            body = ''.join(body_list)
    return body

def hr_(weite=0):
    "hr = horizontal rule, weite in %, Aufruf: html_hr() oder html_hr(85)"
    if weite > 0:
        rule = '<hr width="' + str(weite) + '%" align="center">'
    else:
        rule = '<hr>'
    return rule


def nbsp_(anzahl=1):
    "gibt anzahl nbsp = no break spaces aus, Aufruf: nbsp_() oder nbsp_(7)"
    return '&nbsp;' * anzahl

def h_(text,groesse, align="left"):
    "heading = �erschrift, Aufruf: h_('Hallo',2,align='center')"             
    if 1 <= groesse <= 6:
        return '<h'+ str(groesse) + ' align="' + align  +'">' + text + '</h'+ str(groesse) + '>'
    else: # default: h3
        return '<h3>' + text + '</h3>'

##def _test_():
##    "Test fr die filter_-Funktion"
##    text = 'hall�>\n Walter \nda�& dies\n ��"'
##    print text
##    print '\n\n', filter_(text)
##    textfarbe = 'navy'
##    bg = '#ffffdf'
##    print '\n\n', html_('Test',b_(filter_(text)),textfarbe,bg)

def _ucodetest_():
    "Test fr die ucodefilter_-Funktion"
    text = u'hall\xf6,>\n Walter \nda\xdf & dies\n \xc4\xd6\xdc""'
    print text
    print '\n\n', ucodefilter_(text)
    textfarbe = 'navy'
    bg = '#ffffdf'
    print '\n\n', html_('Test',b_(ucodefilter_(text)),textfarbe,bg)


def test2():
    "Test fr die Tabellen-Funktion"
    liste1 = ('Name', 'Stadt','Position')     
    liste2 = (('John Doe',	'lu',	'Director'),
    ('Jeff Waxman',	'of',	'Manager'),
    ('John Lee',	'ffm',	'Manager'),        
    ('Peter Kenson', 'hu',	'Manager'))
    kopf = table_heading(liste1)
    rest = table_body(liste2,len(liste1))
    tab = table_(kopf+rest)
    query = h_('SELECT-Query',2,align='center') + '\n' + hr_(80)  + '\n'
    textfarbe = '#000000'
    bg = '#efefef'
    print '\n\n', html_('SELECT-Query',query + tab,textfarbe,bg,generated_by='Walter')
    
    
    
# ausprobieren
if __name__== '__main__' :
    test2()
    #_ucodetest_()
