#!/usr/local/bin/python
# -*- coding: Latin1 -*-  
#
## alternativ: -*- coding: utf-8 -*-
#
# gfsql_table.py:    Erzeugt aus den Ergebnissen einer SELECT-Anfrage
#                    eine Tabelle [Tix.ScrolledHList() ]
#                    Version 0.18, 2006-04-11
#
# Grundlage:  das Skript SHList2.py (v 1.1 2000/11/05 19:59:27),
#             Tix Demostration Program
#
##  Benutzung im aufrufenden Skript:
##    liste1 = ['Name', 'Stadt','Position']
##    liste2 = [
##      ('John Doe',	'Ma',	'Director'),
##	('Jeff Waxman',	'Of',	'Manager'),
##	('John Lee',	'Ffm',	'Manager'),        
##	('Peter Kenson', 'Hu',	'Manager')
##    ]       
##    main = Tix.Tk()
##    main.title('gfsql_table-Demo')
##    gfsql_table.gfTable(main, settings, globals_dir, query_list=liste2, heading_list=liste1,breite=22, tabbreite=44)
##
##    oder
##
##    if gfsql_table.gfTable(main,  settings, globals_dir,  query_list=liste2, heading_list=liste1,breite=15, tabbreite=15) == 0:
##        main.destroy()
##
##    oder (am einfachsten)
##
##    call_gfTable(main,  settings, globals_dir, title='gfsql_table-Demo',query=liste2, heading=liste1)
#########################################################################
import string
from Tkinter import *
import os,sys
from os.path import abspath
sys.path.append( os.path.abspath (os.getcwd()) )
import tkMessageBox

def import_error():
    import Tkinter
    import tkMessageBox
    main = Tkinter.Tk() 
    main.withdraw() 
    tkMessageBox.showwarning('ImportError', 'ImportError: Tix not found!') 
    main.quit() 

try:
    import Tix
except ImportError:
    pass


def tix_test():
    import Tkinter 
    w = Tkinter.Tk()    
    w.withdraw()
    ergebnis = None
    try:
        ergebnis = w.tk.eval('package require Tix')
    except:
        ergebnis = None
    w.destroy()
    return ergebnis



main = None

def die():    
    main.destroy()
    sys.exit(0)

def htmlTable(tab_window, settings, globals_dir, query='', result=[], heading=[]):
    """Erzeugt aus der SELECT-Anfrage eine HTML-Tabelle"""  
    import tkFileDialog
    import html_tools
    import gfsql_methods
    import time
    sname = tkFileDialog.asksaveasfilename(filetypes=[(settings.get('html_files'), "*.html *.htm")],initialdir=str(globals_dir['path'])) 
    tab_window.lift()  ## Tabellen-Fenster nach vorne!
    if sname:    
        from string import capitalize  	# neu, vers 0.18
        _heading_ = []			# neu, vers 0.18
        for element in heading:		# neu, vers 0.18
        	_heading_.append(capitalize(element))   
        database = settings.get('Datenbank')  + ' ' + globals_dir['database'] + ' (' + time.strftime("%A %B %d, %Y %I:%M %p",time.localtime(time.time()))  + ')'
        kopf = html_tools.h_(database ,3,align='center') + '<br>\n'
        kopf = kopf + html_tools.h_(query,3,align='center') + '\n' + html_tools.hr_(80) + '\n'
        ##tabkopf = html_tools.table_heading( heading )
        ##tabrest = html_tools.table_body(result,len(heading))
        ## mit Filter:
        tabkopf = html_tools.table_heading( _heading_, _filter_=1 ) ## _filter_ = 1 
        tabrest = html_tools.table_body(result,len(_heading_), _filter_=1 )  ## _filter_ = 1 
        tab = html_tools.table_(tabkopf+tabrest)
        textfarbe = '#000000'
        bg = '#efefef'
        html_tab = html_tools.html_('SELECT-Query',kopf + tab,textfarbe,bg,generated_by="gfsqlite")    
        if ( (not gfsql_methods.test_extension(sname,".html")) and (not gfsql_methods.test_extension(sname,".htm")) ):
                sname = sname + ".html"
        ofp = open(sname,"w") 
        ofp.write(html_tab) 
        ofp.flush() 
        ofp.close() 
        

    
  
def get_Max(headings,query):
        """Bestimmt die Breite (in Zeichen) der ersten Spalte"""
        _debug_ = 0
        max_liste=[]
        for kopf in headings:
            max_ = 1 ## Anfangswert!
            laenge = len( str(kopf) ) + 2 ## kopf wird fett gedruckt => + 2!
            if laenge > max_:
                max_ = laenge
            max_liste.append(max_)
        if _debug_:
            pass
            ##print "kopf: ",max_liste
        for zeile in query:
           i = 0
           for zelle in zeile:
               max_ = 1
               #print str(zelle)
               if string.find(str(zelle),'\r') != -1:
                   ## '\r' gefunden: String mit new Line . . .
                   eintrag = string.split(str(zelle),'\r')
                   for wort in eintrag:
                       laenge = len( wort )
                       if laenge > max_:
                           max_ = laenge
               else:
                   laenge = len( str(zelle) )
               if laenge > max_:
                   max_ = laenge
               if max_liste[i] < max_:
                   max_liste[i] = max_
               i = i + 1                  
        max_ = max(max_liste)
        maximum = 0
        for wert in max_liste:
            maximum = maximum + wert
        max_ = max_liste[0]
        if _debug_:
##            print "tabelle: ",max_liste
##            print "max_: ",max_
##            print "Tabweite: ",maximum
            tkMessageBox.showinfo('Info', "tabelle: "+ str(max_liste) + '\n' + "max_: " + str(max_) + '\n' + "Tabweite: " + str(maximum) )
        return ([max_,maximum])         


def call_gfTable(w, settings, globals_dir, title='',query=[], heading=[],dbpath=''):
       """Call-Methode fuer gfTable"""
       """Beispiel-Aufruf: gfsql_table.call_gfTable( w, settings, globals_dir,title=str(tqs), query=f, heading=names ,dbpath='')
       with    tqs: select-query
               f: Datens�ze der query-Abfrage
               names: Namen der Spalte
       """
       if (len(heading)== 0) or (len(query)==0):
           return  0
       else:
           if w == None:
               w = Tix.Tk()           
           # Tabulatoren und Zeilenumbruch entfernen!
           title = string.expandtabs(title,1)
           title = string.replace(title,'\r','')
           title = string.replace(title,'\n',' ')                      
           w.title(title)
           max_,maximum = get_Max(heading,query)  # get_Max gibt ein Tupel zurueck
           gfTable(w, settings,globals_dir, select_query=title, query_list=query, heading_list=heading,pfad=dbpath, breite=max_,tabbreite=maximum)
           return 1
              
       
def gfTable(w, settings,globals_dir, select_query='', query_list=[], heading_list=[],pfad='',breite=20, tabbreite=20):
    """Erzeugt eine Tix-Tabelle aus heading_list + query_list"""   
    # IN: query_list, heading_list, breite (in Zeichen),  tabbreite (Tabellenbreite), pfad, main_Window w
    # IN: setting & globals_dir for htmlTable
    # OUT: Table for heading_list + query_list using TIX
    if (len(heading_list)== 0) or (len(query_list)==0):
           return  0
       
    header_liste = [] # heading_list

    liste = query_list

    from string import capitalize	# neu, vers 0.18
    for element in heading_list:	# neu, vers 0.18
        header_liste.append(capitalize(element))

    #header_liste = heading_list

    spalten = len(header_liste)

    
    #################################################
    
    # We create the frame and the ScrolledHList widget
    # at the top of the dialog box
    #
    top = Tix.Frame( w, relief=Tix.RAISED, bd=1)

    # Put a simple hierachy into the HList (two levels). Use colors and
    # separator widgets (frames) to make the list look fancy
    #        
    options_string = 'hlist.columns ' +  str(spalten + 1) + ' hlist.header 1'
    top.a = Tix.ScrolledHList(top, options=options_string )  

    top.a.pack( expand=1, fill=Tix.BOTH, padx=10, pady=11, side=Tix.TOP)

    hlist=top.a.hlist

    # Create the title for the HList widget
    #	>> Notice that we have set the hlist.header subwidget option to true
    #      so that the header is displayed
    #
    
    # First some styles for the headers == Kopf der Tabelle
    style={}

    style['header'] = Tix.DisplayStyle(Tix.TEXT, fg='black', refwindow=top,
	anchor=Tix.CENTER, padx=8, pady=2)

    for index in range(spalten):
           hlist.header_create(index, itemtype=Tix.TEXT, text=str(header_liste[index]),
               style=style['header'])
    

    # Notice that we use 3 columns in the hlist widget. This way when the user
    # expands the windows wide, the right side of the header doesn't look
    # chopped off. The following line ensures that the 3 column header is
    # not shown unless the hlist window is wider than its contents.
    #
    hlist.column_width(spalten,1)  

    ## selectbackground='#000000' geht leider nicht . .
    fg_color = '#000000'
    style['list_first'] = Tix.DisplayStyle(Tix.TEXT, refwindow=top,fg=fg_color, bg='#eeeeee', selectforeground='#ffffff') 

    style['list_rest'] = Tix.DisplayStyle(Tix.TEXT, padx=8,  refwindow=top,fg=fg_color, bg='#eeeeee', selectforeground='#ffffff') 


    # Let configure the appearance of the HList subwidget 
    #    
    ##hlist.config(separator='.', width=25, drawbranch=0, indent=0)
    ##hlist.column_width(0, chars=breite)
    hlist.config(separator='.', width=tabbreite, drawbranch=0, indent=0)
    hlist.column_width(0, chars=breite)

    # Create the Table
    #
    ## index: Zaehlervariable
    for index in range( len(liste) ):
        if index == 0:	
            e='.'
        else:
            e= '.'+ str(index) ## e ist ein eindeutiger Schluessel!
            
        zeile = liste[index]   ## Zeile aus Tabelle holen
        
        ## spaltenindex: geht die Spalten einer Zeile durch        
        for spaltenindex in range(spalten):
            if spaltenindex == 0:                   
               hlist.add(e, itemtype=Tix.TEXT, text=str(zeile[spaltenindex]), style=style['list_first'])
            else:   
               hlist.item_create(e, spaltenindex, itemtype=Tix.TEXT, text=str(zeile[spaltenindex]), style=style['list_rest'])
    

    # Use a ButtonBox to hold the buttons.
    #
##    box= Tix.ButtonBox(top, orientation=Tix.HORIZONTAL )
##    box.pack( side=Tix.LEFT, fill=Tix.X, expand=1)
##    
##    box.add( 'html',  text=settings.get('save_as_html'), width=len(settings.get('save_as_html')) + 2,
##	command = lambda einstellungen=settings,globals =globals_dir,fenster=w ,query = select_query,result=query_list ,heading=heading_list: 
##            htmlTable( fenster, einstellungen,globals, query,result,heading) )
##    
##    
##    box.add( 'ok',  text='Ok', width=6,	command = lambda w=w: w.destroy() )
##
##    #box.subwidget('html')['underline']=0
    boxl = Button(top,text=settings.get('save_as_html'),  
            command = lambda einstellungen=settings,globals =globals_dir,fenster=w ,query = select_query,result=query_list ,heading=heading_list: 
            htmlTable( fenster, einstellungen,globals, query,result,heading) )
    boxl.pack(side=LEFT,padx=10, pady=5)
    
    boxr = Button(top, text="Ok", width=6, command = lambda w=w: w.destroy())
    boxr.pack(side=RIGHT,padx=10, pady=5)
    
    top.pack( side=Tix.TOP,  fill=Tix.BOTH, expand=1 )
    return 1
    
# This "if" statement makes it possible to run this script file inside or
# outside of the main demo program "gfsql.pyw".
#
if __name__== '__main__' :
    import gfsqlite_cfg
    settings = gfsqlite_cfg.german_settings 
    globals_dir = {}
    globals_dir['path'] = os.path.abspath (os.getcwd()) 
    globals_dir['database'] = 'test.db'
    idle = 0    ## idle-Flag
    liste1 = ('Name', 'Stadt','Position')     
    liste2 = [
    ('John Doe',	'lu',	'Director'),
	('Jeff Waxman',	'of',	'Manager'),
	('John Lee',	'ffm',	'Manager'),    
	('Peter Kenson', 'hu',	'Manager')
    ]
    ## Import-Test    
    ergebnis = tix_test()
    if (ergebnis == None):
        import_error()
    else:
        main=Tix.Tk()     
        main.protocol('WM_DELETE_WINDOW',die)
        main.title("gfsql_table-Demo")
##        if gfTable(main,settings, globals_dir, select_query="SELECT-Query" ,query_list=liste2, heading_list=liste1) == 0:
##               die()

        call_gfTable(main,settings, globals_dir,title='gfsql_table-Demo',query=liste2, heading=liste1)                      
        if not idle:       
            main.mainloop()


