#!/usr/local/bin/python
# -*- coding: Latin1 -*-  
#
## alternativ: -*- coding: utf-8 -*-
# gfsql_methods.py: Methoden zu gfsqlite.pyw
# Version 0.05, 2006-05-26

import string   
import locale
import gfsqlite_cfg
import umlautCodec

codes = umlautCodec.unicode2org2

## default prompt strings.
## >>> look at gfsqlite_cfg.py for prompt1/prompt2 <<<
settings = gfsqlite_cfg.english_settings 
prompt1 = settings.get('prompt1') 
prompt2 = settings.get('prompt2')  



def schreibTest(datei,pfad,settings):
    """Test auf Schreib-Rechte auf die Gadfly-database 'datei' """
    import tkMessageBox    
    debug = 0
    dateiname_  = datei + '.gfd'  ## wichtig! 
    datname = string.replace(datei,pfad,'')
    if debug:
        print '\nMethode schreib_test: ' + datei
        print '                      ' + dateiname_ 
    try: 
        f = open(dateiname_,"ab")  ## Mode a: append, b: binary 
    except IOError: 
        tkMessageBox.showerror(settings.get('error'), settings.get('db_') + datname + settings.get('write_protected')) 
        return 0 
    else: 
        f.close() 
        return 1 

def arg_test():
    ## Argument schaltet in Test-Modus; wird mit <Strg-U>/<Strg-u> im oberen Textfenster aktiviert
    import sys
    gfsql_test = ''
    ergebnis = 0
    ## ergebnis = 1, falls als Argument 'test' uebergeben wurde!    
    if len(sys.argv) > 1 and (sys.argv[1] != ''):
        gfsql_test = string.lower( sys.argv[1] )
        if (len(gfsql_test) > 0):
            if (string.find(gfsql_test,'test') <> -1):
                ergebnis = 1
    return ergebnis        


def get_locale():
    """benutzt loakle Einstellungen fr die Benutzersprache"""
    env = []
    try:
        env = locale.getdefaultlocale()
        if len(env) > 0: 
            return env[0]
        else:
            return ''
    except :
        return ''

def get_language():
    """stellt die Benutzer-Sprache ein"""
    lan = string.lower( get_locale() )
    if (lan <> ''):
        if (string.find(lan,'de') <> -1) or (string.find(lan,'german') <> -1):
            return 'deutsch'
        else: # Default
            return 'english'
    else: # Default
        return 'english'
        

def sitzungTest(daten): 
    """sitzungTest(daten) stellt fest, ob es sich um eine Sitzungsdatei handelt""" 
    """Test auf prompt1""" 
    retour = 0 
    teststr = prompt1 
    test = string.find(daten,teststr) 
    if test <> -1: 
        retour = 1 
    return retour 
 
def stripSitzungDatei(daten): 
    """gibt eine Sitzungs-Datei als Liste von SQL-Befehlen zurck""" 
    debug = 0
    sep = '+]{~*'  # Separatorzeichen
    erster = string.find(daten,prompt1) 
    letzter = string.rfind(daten,';') 
    text2  = daten[erster:letzter+1] 
    text2 = string.replace(text2,prompt2,' ')  # prompt2 rauswerfen! 
    liste = string.split(text2,prompt1)
    if debug:
        print liste    
    text_ = '' 
    for element in liste: 
        if element <> '': 
            pos = string.rfind(element,';') + 1 
            text_ = text_ + string.strip(element[0:pos]) + sep 
    if debug: 
        print '\n\nstripSitzungDatei: ' + text_ 
    liste  = string.split(text_,sep)
    if debug:
        print liste
    if liste[-1] == '': 
        liste.remove('') 
    return liste 
 
def stripDatei(daten): 
    """gibt eine Datei als Liste von SQL-Befehlen zurck"""    
    debug = 0
    sep = '+]{~*'  # Separatorzeichen
    begin_t = "BEGIN TRANSACTION;"
    liste = string.split(daten,'\n') 
    liste2 = [] 
    for j in range(len(liste)): # Kommentarzeilen entfernen 
        element = string.strip(liste[j]) 
        if string.find(element,'#',0,5) == -1: 
            liste2.append(liste[j]+sep) 
    if debug:
        print '\n\nstripDatei: '
        print liste2 
    daten_ = string.join(liste2,'') 
    liste = string.split(daten_,sep) # Befehle separieren 
    if liste[-1] == '': 
        liste.remove('')
    liste2 = []
    temp = ''
    for j in range( len(liste) ): 
        liste[j] = string.strip(liste[j])
        pos = string.rfind(liste[j],';')
        if (pos == -1): # kein ';' am Ende
            temp = temp + ' ' +  liste[j]            
        else: # ';' am Ende
            if (len(temp) > 0):
                temp = temp + ' ' + liste[j]
                liste2.append( string.strip(temp) )
                temp = ''
            else:    
                liste2.append( liste[j] )
##    for element in liste2:
##        element = element.upper()
##        if cmpTest(element,begin_t):
##            liste2.remove(element)
    test = liste2[0]
    test = test.upper()
    if cmpTest(test,begin_t):
        liste2.remove(liste[0])
    
    if debug:
        print liste2                 
    return liste2

def cmpTest(str1,str2):
    len1 = len(str1)
    len2 = len(str2)
    if (len1 != len2): # Laenge ungleich!
        return 0
    else:
        for j in range( len(str2) ):
            #print str2[j],
            if (str1[j] != str2[j]):  # String ungleich!              
                return 0
        return 1

def datei_lesen (datei): 
    """liest eine Datei, gibt Inhalt zurck, falls erfolgreich, sonst '' """ 
    try: 
        in_file = open(datei,"r") 
        # Datei zum Lesen (r: read) �fnen 
    except IOError: 
        return '' 
    else: 
        text = in_file.read() # Datei lesen 
        in_file.close() # Datei schliessen 
        return text 

def test_extension(Dateiname,Erweiterung):
    Dateiname = string.lower(Dateiname)
    if ( string.rfind(Dateiname,Erweiterung) == -1 ):
        return 0
    else:  ## Erweiterung in Dateiname gefunden
        return 1        

def umlaut_filter(zeile,debug=0):
    "kodiert Sonderzeichen: unicode -> ascii"    
    # die Sonderzeichen werden im Dictionary 'codes' festgelegt
    # Dies funktioniert:
    codes = umlautCodec.unicodeCodes
    
    # Das folgende geht leider nicht . . . 
    #codes = {'\xe4':'�, '\xf6':'�, '\xfc':'', '\xc4':'�, '\xd6':'�, '\xdc':'�, '\xdf':'�}
    text_liste = []
    retext = []
    for element in zeile:
        text_liste.append(element)
    if debug:
        print text_liste    
    #return str( tuple(text) )    
    for i in range(len(text_liste)):
        element = str(text_liste[i])
        buildstr = u''       
        for j in range(len(element)):
            if codes.has_key(element[j]):
                buildstr = buildstr + codes[element[j]]
            else:
                buildstr = buildstr + element[j]
        if debug:
            print 'neu: ' + buildstr # element
        retext.append( buildstr )
    if debug:
        for element in retext:
            print element    
    return str( tuple(retext) )    

def umlautFilter2(_zeile_,debug=0):
    """kodiert Sonderzeichen: unicode -> ascii    
    Die Sonderzeichen werden im Dictionary 'codes' festgelegt
    vgl. die codes im Modul umlautCodec
    experimentell!!!!!
    """
    #codes = umlautCodec.unicode2org2  # s. o.
    #print codes
    _zeile_ = unicode(_zeile_)
    buildstr = ''
    j = 0
    ucodec = ''
    for i in range( len(_zeile_) ):
        if (_zeile_[i] != '\\') and (j == 0):
            buildstr = buildstr + _zeile_[i]
        else:
            # unicode-codec aufbauen
            if (j < 4):
                ucodec = ucodec + _zeile_[i]
                j = j + 1
            else:  # j == 4 -> codec suchen              
                ucodec = ucodec[1:]  # aus '\xf6' wird 'xf6'
                if debug:
                    print "Treffer: " + ucodec,
                    if codes.has_key( ucodec ):
                        print codes[ucodec],
                    print '\n' + _zeile_[i]
                if codes.has_key( ucodec ):    
                    buildstr = buildstr + codes[ucodec] 
                if (_zeile_[i] == '\\'):
                    j = 1
                    ucodec = _zeile_[i]
                else:
                    buildstr = buildstr + _zeile_[i]
                    j = 0
                    ucodec = ''                
    if debug:
            print 'neu: ' + buildstr
    return buildstr

def datei_schreiben (datei, data): 
    """schreibt <data> in eine Datei"""
    from os.path import exists
    if not exists(datei):
        try: 
            out_file = open(datei,"w") 
            # Datei zum Schreiben (w: write) �fnen 
        except IOError: 
            return 0 
        else: 
            out_file.write(data) # Datei lesen 
            out_file.close() # Datei schliessen 
            return 1
    else:
        return 0
