#!/usr/local/bin/python
# -*- coding: utf-8 -*-
# 
## alternativ: -*- coding: Latin1 -*-  
# gfsqliteMain.py: simple SQL-Shell for sqlite-Databases
# Version 0.76, 2013-07-23
# Based upon gfsql.pyw
# W. Spiegel, walter.spiegel@web.de 
# URL: http://gfsqlite.wspiegel.de/
# This is work in progress! 
# Thanks to 
# Aaron Watters (for pp() in gfsqlite_inter.py) 
# Jeff Berliner (for gfplus)
# Michael Owens and Gerhard Häring (for pysqlite)
# D. Richard Hipp (for sqlite)
# Guido van Rossum (for the syntax-highcoloring in IDLE)
# The following files are from IDLE:
# Delegator.py, Percolator.py, WidgetRedirector.py, config.txt
# sqlKeyword.py (original: keyword.py), GfsqlConf.py (original: IdleConf.py),
# CoDelegator.py (original: ColorDelegator.py)
# IDLE-code is Copyright (c) 2001, 2002, 2003 Python Software Foundation; 
# All Rights Reserved (http://www.python.org/2.2.3/license.html)
# 
# Requires Python 2.2/2.3 and
# pysqlite (version 0.3.1 or later)
#########################################
gfsql_url = 'gfsqlite.wspiegel.de/'
    
pgname = 'gfsqlite' 
 
pgversion = '0.76'
 
pgdate = '2013-07-23'
##########################################
##  ==> Import
##########################################
import os,sys,time,string,traceback 
from os.path import abspath,exists,basename,dirname 
import Tkinter
if os.name == 'posix':
    Tkinter.wantobjects = 0
    # tkMessageBox.askyesno wrong result under Linux!
    # see http://mail.python.org/pipermail/python-bugs-list/2004-September/025172.html
from Tkinter import *
import tkMessageBox 

    
def show_error(titel,msg):
    main = Tk() 
    main.withdraw() 
    tkMessageBox.showerror(titel,msg) 
    main.quit()


from tkFileDialog import * 
from ScrolledText import *
import fileinput
import cPickle
## Unterverzeichnis
gfsqliteModule = '/gmodule'
_subdir_ = os.getcwd() + gfsqliteModule
sys.path.append( os.path.abspath ( os.getcwd() ) )
sys.path.append( os.path.abspath ( _subdir_ ) )
## Falls mal nix mehr geht:
## print sys.path

    
try:    
    import gfsqlite_cfg
except ImportError: 
    show_error('Fatal Error!','Module gfsqlite_cfg.py not found!')
    sys.exit(0) 

## Konfiguration: wird von einstellungen_holen()
## überschrieben, falls einstellungen_laden == 1
confi = 'deutsch' 
settings = gfsqlite_cfg.german_settings 
## alternativ: 
## confi = 'english' 
## settings = gfsqlite_cfg.english_settings 

try: 
    ##sys.path.append( os.path.abspath (os.getcwd()) ) 
    import tkSimpleDialog, tkSimpleText, tkDirectoryChooser, tkScrollbox, tkScrolledText
    import gfsql_history, gfsql_methods, gfsql_list, gfsql_win, gfsql_table
    import sqlcoder

except ImportError:
    show_error(settings.get('modul_errror'),settings.get('module_not_found'))
    sys.exit(0)
    
try: 
    import gfsqlite_inter
except ImportError:
    show_error(settings.get('modul_errror'),settings.get('pysqlite_not_found'))
    sys.exit(0)

try:
    import Tix
except ImportError:
    show_error('ImportError','ImportError: Tix not found!')
    sys.exit(0)
##########################################
##### Globals . .  . >>> START
##########################################    
gfsql_home = os.path.abspath( os.getcwd() )  + os.sep 

## IDLE-Flag: auf 1 setzen, wenn in IDLE getestet werden soll! 
idle = 0
 
## Debug-Flag
## Test-Modus wird mit <Alt-U>/<Alt-u> aktiviert
gfsql_debug = 0
##gfsql_debug = gfsql_methods.arg_test()
                
## 
__version__ = '1.1'  # gfplus-Version 
 
## 
tl=[]
app = None
root = None #Tk() 
t1=None 
t2=None 
eingabe='' 

## für History-Klasse 
gfHistory=gfsql_history.History() 
history = '' 

## für pysqlite
gfInter=gfsqlite_inter.Gfinter()

## für DirListe
gfUsed=gfsql_list.DirList()
dbList_dici = {}

## für SQL-Coder
sql_liste = sqlcoder.sqlListe



SERVER=0    # flag added for client/server usage.  Will be set to 1 if the 
            # arguments passed to gfplus appear to request a server connection
            # NOT USED in gfsqlite !!!
            
## TESTConnection-Flag
TESTConnection = 0 

## clear_window-Flag
CLEARWindow = 1

## StepByStep-Flag
StepByStep = 1

dboffen=0 # falls Datenbank offen: 1
databaseChanged=0   # falls Datenbank modifiziert: 1

dbUmfang = 0 # DB-size
 
dateiname='' 
pfad='' 

##
globals_dir = {}
globals_dir['path'] = pfad
globals_dir['database'] = dateiname
globals_dir['db_open'] = dboffen


fenstertitel = '' 
label1 = '' 
 
tabellen_liste=[]
scrollfenster_title = ''
tab_win_open = 0    # Flag for Tab-window

help_win_open = 0    # Flag for Help-window
about_win_open = 0   # Flag for About-window
dbinfo_win_open = 0    # Flag for DBInfo-window
##ini_dici = {'sprache':'deutsch', 'test_connection':'true', 'clear_window':'true'}
ini_dici = {}
ini_dici['sprache'] = 'locale'
ini_dici['test_connection'] = 'true'
ini_dici['clear_window'] = 'true'
ini_dici['stepbystep'] = 'true'

## für parameterFenster3
einstellungen_lan = 0
einstellungen_test = 1
einstellungen_clear_window = 1
einstellungen_stepbystep = 1
## einstellungen_laden == 1  ==> einstellungen_holen()
einstellungen_laden = 1

## default prompt strings.
prompt1 = settings.get('prompt1') 
prompt2 = settings.get('prompt2')

## font-type and font-size
## see also tkSimpleText.py
if os.name == 'posix':
    gf_font_art='bold'
    gf_font_type='courier'
    gf_font_size=12
    gf_font_type2=gf_font_type
else:
    gf_font_art='normal'
    gf_font_type2='courier'
    gf_font_type='courier'
    gf_font_size=10
gf_font=(gf_font_type,gf_font_size,gf_font_art)
## gf_font2 for parameter-window
gf_font2=(gf_font_type2,gf_font_size,gf_font_art)
##########################################
##### Globals . .  . >>> END
##########################################
def die_():
   if tkMessageBox.askyesno(settings.get('End_Menu') + '?',settings.get('exit_gfsqlite') ):
       die()

def die(): 
   """Beendet gfsqlite"""
   if dboffen:
        app._ende_.set(1) # wichtig!!
        app._weiter_.set(1)   # so greift man auf sqleditor-Eigenschaften zu!
        gfInter.gfquit(dboffen)
        print settings.get('db_') + dateiname + settings.get('closed')        
   dbList_speichern()     
   if os.name == 'posix': 
       root.quit() 
   else: 
        root.destroy() 
        if not idle: 
            sys.exit(0) 
 
 
################################################
def debug_mode(event):
    """Schaltet in Debug-Mode: Fehlermeldungen ins untere Fenster"""
    global gfsql_debug  ## debug_mode changes gfsql_debug!
    _debug_ = gfsql_debug
    
    if (_debug_ == 0):
        gfsql_debug = 1
        ausgabe("Debug-Mode: ON! Python-System-" + settings.get('path') + ":")
        sys_path = ''
        for element in sys.path:
            sys_path = sys_path + element + '\n'
        ausgabe( sys_path )
        ausgabe( settings.get('gfsql_path') + gfsql_home)
        ausgabe(settings.get('debug_info'))
        ## PS: Switch off the <Clear Window>-flag in the option-menu! 
    else: # _debug_ == 1
        gfsql_debug = 0
        ausgabe("Debug-Mode: OFF!\n")
    
def set_globals_dir():
    """Datenstruktur globals_dir setzen"""        
    global globals_dir
    globals_dir['path'] = pfad
    globals_dir['database'] = dateiname
    globals_dir['db_open'] = dboffen


def init_dbDici(max):
    """Datenstruktur dbList_dici initialisieren"""        
    global dbList_dici
    for i in range(max):
        dbList_dici[i] = ''
    
    
def dbList_speichern():
    """DB-Liste speichern in der Datei settings.get('dblist_file')"""        
    global dbList_dici
    laenge = gfUsed.listLength()    
    init_dbDici(gfUsed.DirMax)   ## wichtig!!
    for i in range(laenge):
        dbList_dici[i] = gfUsed.DirListe[i]
        ##alternativ:
        ##dbList_dici.update({i:gfUsed.DirListe[i]})        
    try:
        dbList_datei = open(gfsql_home + settings.get('dblist_file'),'wb')
        cPickle.dump(dbList_dici,dbList_datei)
        dbList_datei.close()
    except:
        tkMessageBox.showerror(settings.get('error'), settings.get('dblist_error') )             

def dbDici2gfUsed(max):
    """Wandelt das dbUsed_Dicitionary in eine gfUsed-Liste"""            
    tempUsed=gfsql_list.DirList()
    tempListe = []
    for i in range(max):
        tempListe.append(dbList_dici.get(i))
    tempListe.reverse()
    for element in tempListe:
        if element <> '':
           tempUsed.addEntry(element)
    return tempUsed       

def dbList_holen(max,dbList_file=''):
    """Liest die DB-Liste aus der Datei settings.get('dblist_file')"""        
    global dbList_dici, gfUsed
    try:
        if dbList_file<>'':
            dbList_datei = open(dbList_file,'rb')
        else:    
            dbList_datei = open(gfsql_home + settings.get('dblist_file'),'rb')
        dbList_dici = cPickle.load(dbList_datei)
        dbList_datei.close()
        gfUsed = dbDici2gfUsed(max)
    except:     ## Probleme beim Lesen, die dblist_file wird neu initialisiert
        init_dbDici(max)
        dbList_datei = open(gfsql_home + settings.get('dblist_file'),'wb')
        cPickle.dump(dbList_dici,dbList_datei)
        dbList_datei.close()
        gfUsed = dbDici2gfUsed(max)        
        ##tkMessageBox.showerror(settings.get('error'), settings.get('dblist_error') )             


def einstellungen_holen():
    """Liest die Einstellungen aus der Datei settings.get('init_file')"""
    global ini_dici, TESTConnection, confi, settings, StepByStep, CLEARWindow
    try:
        ini_datei = open(gfsql_home + settings.get('init_file'),'rb')
        ini_dici = cPickle.load(ini_datei)
        ini_datei.close()
        if (ini_dici.get('test_connection') == "false"):
            TESTConnection = 0
        else:    
            TESTConnection = 1
        if (ini_dici.get('clear_window') == "false"):
            CLEARWindow = 0
        else:    
            CLEARWindow = 1
        if (ini_dici.get('stepbystep') == "false"):
            StepByStep = 0
        else:    
            StepByStep = 1
                        
        confi = ini_dici.get('sprache')
        if (confi == 'locale'):
            confi = gfsql_methods.get_language()
        if (confi == 'deutsch'):
            settings = gfsqlite_cfg.german_settings
        else:    ## confi == 'english'!!
            settings = gfsqlite_cfg.english_settings
        return 1    
    except:
        ##show_error(settings.get('error'), settings.get('init_error') )
        einstellungen_schreiben(info=0)
        return 0

def einstellungen_schreiben(info=1):
        try:
            ini_datei = open(gfsql_home + settings.get('init_file'),'wb')
            cPickle.dump(ini_dici,ini_datei)
            ini_datei.close()
            if info:
                tkMessageBox.showinfo(settings.get('confi'), settings.get('confi_saved') )                         
        except:
            tkMessageBox.showerror(settings.get('error'), settings.get('init_error') )                        
    
################################################
def bearbeiteBefehl(befehl): 
    """SQL-Befehl bearbeiten"""
    global t2,t1
    if befehl <> '':
        set_cursor()
        t1.insert(END,befehl) 
        gfmain(argument=1,sqlbefehl=befehl) ## Befehl abarbeiten!
        gfHistory.addEntry(befehl)          ## Befehl zur History-Liste hinzufügen
        gfHistory.resetHistory()            ##
        t1.update()
        t2.update()
        
        
def fehler( oname ):
    name = os.path.split( oname )
    feedback =  settings.get('could') + ' "' + name[1] + '" ' + settings.get('not_open')
    tkMessageBox.showerror(settings.get('error'),feedback) 
######################################
def is_sqlite_db(oname):
    #print "\nHier is_sqlite_db\n"
    magic_stringdb2 = "** This file contains an SQLite 2.1 database **"
    magic_stringdb3 = "SQLite format 3"
    number_of_bytes = len(magic_stringdb2)
    if exists(oname):
        try:
            datei = file(oname,"r")
            ergebnis = datei.read(number_of_bytes)
            datei.close()
            dbname = basename(oname) 
            if string.find(ergebnis,magic_stringdb2) != -1:
                print '\n"' + dbname + '" is a SQLite Version 2.1 Database\n'
                return 1
            elif string.find(ergebnis,magic_stringdb3) != -1:
                print '\n"' + dbname + '" is a SQLite Version 3 Database\n'
                return 1
            else:
                return 0
        except:
            if gfsql_debug:
                ausgabe("Pfad+Datei: " + oname)
            return 0
    else: ## file 'oname' does not exists!
        if gfsql_debug:
            ausgabe("Pfad+Datei: " + oname)
        return 0
        

    
def gfdefn(): 
    """List defn from one Table of database"""
    ## benutzt gfInter.gftable(SERVER) sowie gfInter.gfdefn(SERVER,table)
    global tabellen_liste, scrollfenster_title, t2,t1
    myCancel = 0
    ergebnis = gfInter.gftable(SERVER) 
    ergebnis_liste = string.split( ergebnis ) ## enthält Tabellen
    del ergebnis_liste[:2]       ## Kopf rauswerfen
    ## print ergebnis_liste[0]  ## Debug
    if len(ergebnis_liste) > 1:  ## mehr als ein Eintrag: Listbox 
        ergebnis_liste.sort() 
        tabellen_liste = ergebnis_liste
        scrollfenster_title = settings.get('win_Tables')
        data = gfsql_win.scrollfenster(root,title=scrollfenster_title ,tab_list=tabellen_liste)  ## Scrollfenster mit Tabellen        
        if data.result != None:
            table = ergebnis_liste[data.result]
            ergebnis = gfInter.gfdefn(SERVER,table)
        else:           ## data.result == None
            myCancel = 1
    else : ## es gibt nur eine Tabelle! 
        table = ergebnis_liste[0]
        ergebnis = gfInter.gfdefn(SERVER,table)

    if not myCancel:
        low_result = string.lower(ergebnis)
        if string.find(low_result,'view') != -1:
            t2.insert(END,'\nView: ' + table + settings.get('from_db') + dateiname )            
        else:   ## table
            t2.insert(END,'\n' + settings.get('table') + table + settings.get('from_db') + dateiname )
        ausgabe( ergebnis ) 
    else:
        t1.focus_set()
        set_cursor()
 
 
def ausgabe(text,fenster='t2'): 
    """Aufruf: ausgabe(text) bzw. ausgabe(text,t1); Voreinstellung: unteres Fenster t2""" 
    global t1,t2 
    if fenster == 't2': 
        t2.insert(END, '\n' + text )
        t2.yview(END) 
        t2.insert(END,'\n')
        t2.see(END) 
        t1.yview(END)     
        t1.focus_set() 
    else: 
        t1.insert(END, '\n' + text ) 
        t1.mark_set("insert", "end-1c")
        t1.insert("insert",'\n')
        t1.see("insert")
        t1.yview(END) 
        t1.update_idletasks()

def show_prompt(mark,text): 
    """Call: show_prompt(END,zusatz+prompt1) =>  shows the gfsql-Prompt """
    global t1
    t1.insert(mark,text) 
    t1.yview(mark)
    t1.update_idletasks()
 
def set_cursor(window='t1'): 
    """Call: set_cursor() => set the cursor to the
    end of the session in the window """
    global t1, t2
    if window == 't1':
        win = t1
    else:
        win = t2
    win.mark_set("insert", "end-1c")
    win.see("insert")
    win.yview(END) 
    win.update_idletasks()


         
 
 
def scan_eingabe(): 
    """bearbeitet die Benutzer-Eingabe!""" 
    global t1,t2,eingabe, history 
 
    debug = 0
    fehler = 0
    weiter = 0
    tempeingabe = '' 
    historyeingabe = '' 
    eingabe_ =  '' 
    offset1 = len( prompt1)
    offset2 = len( string.lstrip(prompt2) )
    
    eingabe_ = t1.get('1.0',END) # lese Text-Fenster t1 
    ##eingabe_ = unicode(t1.get('1.0',END) , 'iso-8859-1') # lese Text-Fenster t1
    if debug: 
        print eingabe_ 
    ## suche prompt 
    gf = string.rfind (eingabe_, string.strip(prompt1) ) 
    _gf = string.rfind (eingabe_, string.strip(prompt2) ) 
 
    if debug: 
        print prompt1,gf,'   ',prompt2,_gf,' Länge eingabe: ', len(eingabe_), ' offset2:',str(offset2) 
 
    if gf== -1 and _gf== -1:            # weder prompt1 noch prompt2 gefunden!!! 
        fehler = 1 
    elif (_gf != -1) and (_gf > gf):    # !!! zuletzt prompt2
        tempeingabe = eingabe_[int(_gf+offset2):len(eingabe_)] 
        weiter = 1 
    elif (gf != -1) and (gf > _gf):     # zuletzt prompt1
        tempeingabe = eingabe_[int(gf+offset1):len(eingabe_)] 
        weiter = 0
    else:  ## gf == _gf und gf != -1, das kann nicht sein!!!
        fehler = 1
        
    if debug: 
        print tempeingabe 
 
    historyeingabe = tempeingabe        # für History 
    tempeingabe = string.replace(tempeingabe,'\n',' ') # new lines entfernen 
    nospaces_eingabe = string.replace(tempeingabe,' ','') # spaces entfernen 
    if debug: 
        print 'tempeingabe: ', tempeingabe 
        print 'tempeingabe ohne Spaces: ', nospaces_eingabe 
 
    if tempeingabe == '' or nospaces_eingabe == '':   # FEHLER! 
        fehler = 1 
 
    if debug: 
        print 'fehler: ',fehler 
 
    if not fehler: 
        if weiter:  # '... ' gefunden => weiter == 1 
            eingabe = eingabe + ' ' + tempeingabe 
            history = history + historyeingabe 
        else:             # prompt1 gefunden => weiter == 0 
            eingabe = tempeingabe 
            history = historyeingabe 
 
        gfHistory.addEntry(string.rstrip(history)) ## wichtig für die History-Liste!
        gfHistory.resetHistory()            ## 
        set_cursor()
    if debug: 
        print 'eingabe: ',eingabe , '\n weiter: ',weiter 
        tkMessageBox.showinfo("scan_eingabe: " , eingabe) 
        tkMessageBox.showinfo("scan_eingabe: " , history) 
    #fehler = 1    # im Testfall 
    return fehler 
 
 
def befehl_ausgeben(befehl): 
    """befehl_ausgeben(befehl) gibt 'befehl' im oberen Fenster aus"""
    offset = len(prompt1)
    str_offset = str(offset)
    pos_offset = '+' + str_offset + 'c'
    if befehl <> '':
        set_cursor()
        pos = t1.search(prompt1,END,backwards=TRUE) # Prompt suchen 
        t1.delete(pos + pos_offset, END) # eine Zeile hoch 
        t1.insert(pos + pos_offset, befehl)  # Befehl einfügen 
        t1.yview(END)
        t1.update_idletasks()
 
 
def vorigerBefehl(event):
    voriger_Befehl()
    
def voriger_Befehl():    
    if dboffen:
        befehl = '' 
        befehl = gfHistory.prev()
        if befehl <> '':
            befehl_ausgeben(befehl) 
 
 
def naechsterBefehl(event):
    naechster_Befehl()
    
def naechster_Befehl():   
    if dboffen:    
        befehl = '' 
        befehl = gfHistory.next()
        if befehl <> '':
            befehl_ausgeben(befehl) 

 
def tabelleZeigen(event):
    """tabelleZeigen gibt die letzte Select-Anfrage mit Hilfe der MultiListbox aus!"""
    tabelle_Zeigen()
        
def tabelle_Zeigen():
    """tabelleZeigen gibt die letzte Select-Anfrage mit Hilfe der MultiListbox aus!"""
    if dboffen:    
        befehl = '' 
        befehl = gfHistory.letzteAnfrage() ## vorigen Befehl holen    
        if befehl <> '':
            gfmain(argument=1,sqlbefehl=befehl,tixTabelle=1)                
########################################## 
def gfcommit():
    global dboffen, dateiname, databaseChanged
    if not ( gfInter.gfcommit(dboffen) ):
        msg = settings.get('db_') + dateiname + settings.get('write_protected')
        msg = msg + '\n' + settings.get('Datenbank') + ' ' + settings.get('wird_geschlossen')
        tkMessageBox.showerror(settings.get('error'), msg)            
        gfrollback()
        line = '\n' + settings.get('db_') + dateiname + settings.get('closed') 
        ausgabe( line ,fenster='t1') 
        app.t.title(pgname)
        dboffen = 0
        databaseChanged=0
        dateiname = ''
    else:
        databaseChanged=0        
    
def gfrollback():
    global dboffen, databaseChanged
    gfInter.gfrollback(dboffen)
    databaseChanged=0

def gfdesc(table=None):
    global SERVER
    return gfInter.gfdesc( SERVER, table,settings.get('table'),settings.get('tab_column') )
 
def gfmain_(event): 
    """für key-Event-Binding => Wrapper-Funktion""" 
    gfmain()
    
 
## gfmain() function is borrowed from Jeff Berliners gfplus
## see http://endeavor.med.nyu.edu/~jeff/gfplus/   
## Thanks Jeff!!  
def gfmain(debug=0,argument=0,sqlbefehl='',tixTabelle=0):    
    ##   kw is a dictionary which defines all non-sql gfplus commands. 
    ##   the value of each item is a callback function to be executed if the 
    ##   command is invoked. 
    kw1 = { 
          'commit':  gfcommit, 
          'rollback': gfrollback 
          } 
 
    ##  Callbacks for functions which take a single argument.  I'm sure there's a 
    ##  better way to do this... 
    kw2 = { 
          'desc':     gfdesc, 
          'describe': gfdesc 
          } 
  
    global t1,t2,eingabe, dateiname, databaseChanged
 
    debug = 0 
    weiter = 0 
    fehler = 0 
    select_flag = 0 
 
    zusatz = '\n' 
 
    qs = '' 
    tqs = ''
    
    offset = len(prompt1)
    str_offset = str(offset)
    pos_offset = '+' + str_offset + 'c'

 
    if dateiname == '':        # keine Datenbank geöffnet . . . 
        return 
 
    if argument:    # SQL-Datei abarbeiten 
        eingabe = sqlbefehl
        if debug:
            print eingabe
    else: 
        fehler = scan_eingabe() 
 
 
    if fehler: 
        tkMessageBox.showerror(settings.get('error'), settings.get('sorry')) 
        pos1 = t1.search(prompt1,END,backwards=TRUE) # Prompt suchen 
        t1.delete(pos1 + pos_offset , END) # löschen 
        t1.yview(END)   # Cursor setzen!
        t1.update_idletasks()
    else: 
        try: 
            tqs = eingabe 
        except EOFError:    # Catch a ctrl-D 
            gfcommit() 
        while 1: 
                try:                    
                    if string.strip(tqs)[-1] == ';': 
                        qs = qs + ' ' + string.strip(tqs)[:-1] 
                        qf = string.split(qs) 
                        if debug: 
                            tkMessageBox.showinfo("gfmain: ", qf) 
                        cmd = string.lower(string.strip(qf[0])) 
                        if debug: 
                            tkMessageBox.showinfo("gfmain: ", cmd) 
                        if cmd in kw1.keys() and cmd == string.lower(string.strip(qs)): ## commit, rollback
                            apply(kw1.get(cmd))  #command was given, use callback..
                            if tixTabelle == 0:
                                show_prompt(END,zusatz+prompt1)
                        elif cmd in kw2.keys(): ## desc, describe, eigentlich unnötig
                            try: 
                                ausgabe( apply(kw2.get(cmd),(qf[1],)) )
                                if tixTabelle == 0:
                                    show_prompt(END,zusatz+prompt1) 
                            except IndexError:                                
                                ausgabe( settings.get('syntax_error') + cmd + settings.get('command') )
                                if tixTabelle == 0:
                                    show_prompt(END,zusatz+prompt1) 
                                break 
                        else:   # assume sql statement 
                            try: 
                                if debug: 
                                    tkMessageBox.showinfo("gfmain: ", qs)
                                exec_result = gfInter.exec_command(qs)
                                ## hier passiert der Unicode-Fehler!!!
                                if (exec_result == 0):  ## Fehler!
                                    ##print 'Unicode-Fehler!'
                                    ausgabe ( settings.get('exec_error') + '\n' + str( qs) )                                    
                            except:   # Gadfly returned an error, use traceback to 
                                      # print it. 
                                type, value = sys.exc_info()[:2] 
                                ausgabe( string.joinfields(traceback.format_exception_only(type, value)) )
                                if tixTabelle == 0:
                                    show_prompt(END,zusatz+prompt1) 
                                gfrollback()  # Fehler: DB zurücksetzen! <<<<<<<<<<<<<<<<<<<<
                                break 
                            if string.lower(qf[0]) == 'select':   # display results 
                                select_flag = 1 
                                f = gfInter.exec_fetchall()
                                #datensatz = len(f)
                                if len(f) > 0:
                                    if tixTabelle == 1:
                                        names = gfInter.exec_desc()
                                        gfsql_table.call_gfTable( None, settings, globals_dir, title=str(tqs), query=f, heading=names )
                                    else:    
                                        ausgabe( gfInter.gf_select(SERVER,anfrage=qs) )                                    
                                else:                   
                                    ausgabe(settings.get('no_rows') )
                            if tixTabelle == 0:        
                                show_prompt(END,zusatz+prompt1) 
                            if not select_flag: 
                                ##gfcommit()        # Kein select, also DDL-Befehl, sichern!! <<<<<<<<<<<<<<<<<<<<
                                databaseChanged = 1 # No select-query => Database has changed
                        break 
                    else: 
                        qs = qs + ' ' + string.strip(tqs)  # continue to next line, append to qs.                                                       
                        show_prompt(END,zusatz+prompt2) 
                        break 
                except IndexError: 
                    try: 
                        show_prompt(END,zusatz+prompt2)
                    except EOFError: 
                        gfcommit() 
                        break  # Catch a ctrl-d proplerly. 
                    continue 
                except EOFError: 
                    gfcommit() 
                    break    # ditto. 
                try: 
                    if string.strip(tqs)[-1] != ';': 
                        qs = qs +' '+ tqs 
                        show_prompt(END,zusatz+prompt2) 
                        break 
                except IndexError:     # someone entered a blank line... 
                    while not tqs:         # until a string is entered, keep prompting 
                        try: 
                            show_prompt(END,zusatz+prompt2) 
                        except EOFError: 
                            gfcommit() 
                            break 
################################################
def sqlCode(arg=None):
    """Gibt den SQL-Code im oberen Fenster aus"""
    global dboffen
    if dboffen: # nur bei offener DB einfuegen!
        t1.insert(END, arg ) 
        t1.mark_set("insert", "end-2c")
        t1.see("insert")
        t1.yview(END) 
        t1.update_idletasks()

################################################
def dbUsed(arg=None):
    """Verwaltet den Zugriff auf die Liste der letzten 5 benutzten Datenbanken"""
    global pfad,dateiname,dboffen, gfUsed 
    debug = 0
    if debug:
        print arg
    pfad_neu = dirname(arg)
    dateiname_neu = basename(arg)         
    if app.dbclose(frage=1):    
        if not (exists( abspath(arg) )  ):    
            feedback =  settings.get('could_db') + ' ' + dateiname_neu +  ' '  + settings.get('not_open')
            tkMessageBox.showerror(settings.get('error'),feedback) 
            gfUsed.delEntry(arg)
            app.update_dbUsedMenu()
        else:
            oname = arg
            if is_sqlite_db(oname):                
                if gfInter.gfinit(dateiname_neu,pfad_neu+os.sep):
                    if gfInter.gftest():
                        pfad = pfad_neu
                        dateiname = dateiname_neu
                        print settings.get('path') + ': ' + pfad + os.sep + ', '+ settings.get('Datenbank') + ': ' + dateiname + '\n'
                        app.start() 
                        dboffen = 1
                        gfUsed.swapFirst(arg)
                        app.update_dbUsedMenu()                    
                        set_globals_dir()
                    else:
                        feedback =  settings.get('db_locked') 
                        tkMessageBox.showerror(settings.get('error'),feedback)
                        dboffen = 0  ## ????
                        dateiname = ''  ### ?????                    
                        
                else:  ## dieser Fall sollte nicht eintreten . . .
                    feedback =  settings.get('could_db') + ' ' + dateiname_neu +  ' ' + settings.get('place') + ' ' + pfad_neu + ' ' + settings.get('not_open')
                    tkMessageBox.showerror(settings.get('error'),feedback)
                    dboffen = 0  ## ????
                    dateiname = ''  ### ?????
            else:   ## file isn't a sqlite database!
                feedback =  dateiname +  ' '  + settings.get('no_sqlite_db')
                tkMessageBox.showerror(settings.get('error'),feedback)                        
                dboffen = 0 
                dateiname = '' 
                set_globals_dir()

                        
 
################################################   
class parameterfenster3(tkSimpleDialog.Dialog): 
    # abgeleitet aus tkSimpleDialog
    global einstellungen_lan, einstellungen_test, einstellungen_stepbystep

    def body(self, master):
        global ini_dici
        self.title( settings.get('confi'))        
##        if os.name == 'posix':
##            Label(master, text=settings.get('init_language'),font=gf_font,anchor=W).grid(row=0) 
##            Label(master, text=settings.get('init_clear_window'),font=gf_font,anchor=W).grid(row=1)                         
##
##        else:
        Label(master, text=settings.get('init_language'),font=gf_font2,anchor=W).grid(row=0) 
        Label(master, text=settings.get('init_clear_window'),font=gf_font2,anchor=W).grid(row=1)
        Label(master, text=settings.get('init_stepbystep'),font=gf_font2,anchor=W).grid(row=2)             
        
        self.ret_lan = IntVar(master)
        self.ret_lan.set(einstellungen_lan)
        Radiobutton(master,text='locale',variable=self.ret_lan,value=0).grid(row=0, column=1) 
        Radiobutton(master,text='english',variable=self.ret_lan,value=1).grid(row=0, column=2) 
        Radiobutton(master,text='deutsch',variable=self.ret_lan,value=2).grid(row=0, column=3) 


        self.ret_clear = IntVar(master)
        self.ret_clear.set(einstellungen_clear_window)
        Checkbutton(master,variable=self.ret_clear).grid(row=1, column=1) 
        
        self.ret_stepbystep = IntVar(master)
        self.ret_stepbystep.set(einstellungen_stepbystep)
        Checkbutton(master,variable=self.ret_stepbystep).grid(row=2, column=1)
 
    def apply(self): 
        self.a1 = self.ret_lan.get() 
        self.a3 = self.ret_clear.get()                
        self.a4 = self.ret_stepbystep.get()        
        self.result = 1 

class sqleditor: 
    """Main-Klasse von gfsqlite"""

    from Percolator import Percolator
    from CoDelegator import CoDelegator
    
    def __init__(self, parent): 
        global t1 
        global t2 
        if parent == None: 
            self.t = Tk() 
        else: 
            self.t = parent

        self.t.withdraw()

        _erg_ = gfsqlite_inter.get_sqlite_version()
        if len(_erg_) == 3:
            self._is_version3_ = int(_erg_[0])
            self._pysqlite_ver_ = _erg_[1]
            self._sqlite_ver_ = _erg_[2]
        else: # Default-Einstellung: alte SQLite-Version/pysqlite-Verson . . .
            self._is_version3_ = 0
            self._pysqlite_ver_ = "0.5"
            self._sqlite_ver_ = "2.x"
                
        if self._is_version3_:
            self.t.title(settings.get('gfsql') + ', ' + pgversion + ' (sqlite 3.x-Version)')    #  Programmversion
        else:
            self.t.title(settings.get('gfsql') + ', ' + pgversion + ' (sqlite 2.x-Version)')    #  Programmversion


        self.windows = None 

        self._weiter_ = IntVar()
        self._ende_ = IntVar()
         
        self.bar = Menu( self.t ) 
 
        self.filem = Menu(self.bar) 
        self.filem.add_command(label=settings.get('sitzung_open'), command=self.openfile) 
        self.filem.add_command(label=settings.get('sitzung_save'), command=self.savefile) 
        self.filem.add_separator() 
        self.filem.add_command(label=settings.get('SQL_Datei'), command=self.openSQLfile) 
        self.filem.add_separator() 
        self.filem.add_command(label=settings.get('clear_oben'), command=self.cl_oben) 
        self.filem.add_command(label=settings.get('clear_unten'), command=self.cl_unten) 
        self.filem.add_separator() 
        self.filem.add_command(label=settings.get('save_quit_menu'), command=self.schliessen) 
        self.filem.add_separator() 
        self.filem.add_command(label=settings.get('End_Menu'), command=self.beenden)
        

        self.sqlCoderMenu = Menu(self.bar,tearoff=0)
        laenge = len(sql_liste)
        for i in range(laenge):
            argument =  sql_liste[i]
            self.sqlCoderMenu.add_command(label=argument, command=(lambda arg=argument : sqlCode(arg) ) )
            
        ###########################    
        self.dbUsedMenu = Menu(self.bar,tearoff=0)    
        laenge = gfUsed.listLength()
        for i in range(laenge):
            argument =  gfUsed.DirListe[i]
            ##self.dbUsedMenu.add_command(label=argument, command=dbUsed2 )
            self.dbUsedMenu.add_command(label=argument, command=(lambda arg=argument : dbUsed(arg) ) )

        self.sqlm = Menu(self.bar) 
        self.sqlm.add_command(label=settings.get('DBopen'), command=self.dbopen) 
        self.sqlm.add_command(label=settings.get('DBclose'), command=self.dbclose) 
        self.sqlm.add_command(label=settings.get('DBnew'), command=self.dbcreate)
        self.sqlm.add_separator()
        self.sqlm.add_command(label='DB-Info', command=self.holeDBinfo)                 
        self.sqlm.add_separator()
        self.sqlm.add_cascade(label='History', menu=self.dbUsedMenu)  
        self.sqlm.add_separator()
        self.sqlm.add_cascade(label='SQL-Fragment', menu=self.sqlCoderMenu)
        self.sqlm.add_separator()         
        self.sqlm.add_command(label=settings.get('Tabelle'), command=self.zeigen) 
        self.sqlm.add_command(label=settings.get('Table_defn'), command=self.defn_zeigen) 
        self.sqlm.add_command(label=settings.get('One_Table_defn'), command=self.table_zeigen) 
        self.sqlm.add_separator() 
        self.sqlm.add_command(label=settings.get('query'), command=gfmain) 
        self.sqlm.add_separator() 
        self.sqlm.add_command(label=settings.get('query_list'), command=self.clear_query_list )
##        self.sqlm.add_command(label=settings.get('query_list'), command=self.clear_query_list, state=DISABLED )         
        self.sqlm.add_separator() 
        self.sqlm.add_command(label=settings.get('export_db'), command=self.export_db ) 
        self.sqlm.add_command(label=settings.get('dia_export'), command=self.dia_export ) 
         
##        self.sqlm.add_separator() 
##        self.sqlm.add_command(label="commit", command=gfcommit) 
##        self.sqlm.add_command(label="rollback", command=gfrollback) 
 
        self.optm = Menu(self.bar) 
        self.optm.add_command(label=settings.get('setting'), command=self.confi_wechseln) 
        self.optm.add_separator()
        self.optm.add_command(label=settings.get('dblist_laden'), command=self.getNewHistoryList )
        self.optm.add_separator() 
        self.optm.add_command(label=settings.get('init_show'), command=self.einstellungen_anzeigen) 
        self.optm.add_command(label=settings.get('init_load'), command=self.einstellungen_laden) 
        self.optm.add_command(label=settings.get('init_store'), command=self.einstellungen_speichern) 
 
        self.helpm = Menu(self.bar)
        self.helpm.add_command(label='SQLite-Version', command=self.sqlite_version) 
        self.helpm.add_separator()         
        self.helpm.add_command(label=settings.get('Hilfe'), command=self.hilfe) 
        self.helpm.add_command(label=settings.get('Info'), command=self.about)


 
        ##settings.get('') 
        self.bar.add_cascade(label=settings.get('Datei'), menu=self.filem) 
        self.bar.add_cascade(label=settings.get('Datenbank'), menu=self.sqlm) 
        self.bar.add_cascade(label=settings.get('Einstellungen'), menu=self.optm) 
        self.bar.add_cascade(label=settings.get('Hilfe'), menu=self.helpm) 
         
        self.t.config(menu=self.bar) 
 
        ################################ 
        self.fupper = Frame(self.t,width=640) 
        self.fupper.pack(expand=1, fill=BOTH) 
 
 
        self.upper_menu = Menu(self.fupper,tearoff=0) 
         
        self.upper_menu.add_command(label=settings.get('DBopen'), command=self.dbopen) 
        self.upper_menu.add_separator() 
        self.upper_menu.add_command(label=settings.get('SQL_Datei'), command=self.openSQLfile) 
        self.upper_menu.add_separator()
        self.upper_menu.add_cascade(label='History', menu=self.dbUsedMenu)         
        self.upper_menu.add_separator()
        self.upper_menu.add_cascade(label='SQL-Fragment', menu=self.sqlCoderMenu)
        self.upper_menu.add_separator()        
        self.upper_menu.add_command(label=settings.get('tk_cut'), command=(lambda arg='t1',s=self: s.gf_cut(arg) )  )      
        self.upper_menu.add_command(label=settings.get('tk_copy'), command=(lambda arg='t1',s=self: s.gf_copy(arg) )  ) 
        self.upper_menu.add_command(label=settings.get('tk_paste'), command=(lambda arg='t1',s=self: s.gf_paste(arg) )  )

                 
        

         
##        if os.name == 'posix': 
##            t1 = ScrolledText(self.fupper,width=70,height=15,relief=RAISED,font=gf_font,bd=2,background="white")
##            ##t1 = tkScrolledText.tkScrolledText(self.fupper,width=70,height=16,relief=RAISED,bd=2,background="white", padx=5, wrap='none') 
##        else: 
##            t1 = ScrolledText(self.fupper,width=70,height=15,relief=RAISED,font="systemfixed",bd=2,background="white") 
##            ##t1 = tkScrolledText.tkScrolledText(self.fupper,width=70,height=16,relief=RAISED,font="systemfixed",bd=2,background="white", padx=5, wrap='none')
        t1 = ScrolledText(self.fupper,width=70,height=15,relief=RAISED,font=gf_font,bd=2,background="white")    
        t1.pack(fill=BOTH, expand=1)
        self.per = per = self.Percolator(t1)
        self.color = color = self.CoDelegator(); per.insertfilter(color)


        t1.bind("<Button-3>",self.popup)
        
        t1.bind("<F4>",gfmain_) 
        t1.bind("<Alt-X>",gfmain_) 
        t1.bind("<Alt-x>",gfmain_)
        
        ##t1.bind("<Return>",gfmain_)  ## Das geht nicht gut!!
        ##t1.bind("<Key-Escape>",gfmain_)  ## Das geht, ist aber nicht empfehlenswert! 
        

        t1.bind("<F5>",vorigerBefehl)
        t1.bind("<Alt-p>",vorigerBefehl) 
        t1.bind("<Alt-P>",vorigerBefehl) 
 
 
        t1.bind("<F6>",naechsterBefehl) 
        t1.bind("<Alt-n>",naechsterBefehl) 
        t1.bind("<Alt-N>",naechsterBefehl)
        
        t1.bind("<F8>",tabelleZeigen)
        t1.bind("<Alt-t>",tabelleZeigen) 
        t1.bind("<Alt-T>",tabelleZeigen)


        t1.bind("<Alt-c>",self.cl_) 
        t1.bind("<Alt-C>",self.cl_)
        
        t1.bind("<Escape>",self.EscapeHandler)
        t1.bind("<Control_L>",self.ControlHandler) # left Strg!
        
        ## Es geht auch beispielsweise:
        ##t1.bind("<Control-Up>",vorigerBefehl) 
        ##t1.bind("<Control-Down>",naechsterBefehl) 
        ##t1.bind("<Shift-Up>",vorigerBefehl) 
        ##t1.bind("<Shift-Down>",naechsterBefehl) 
        ##t1.bind("<Alt-Up>",vorigerBefehl) 
        ##t1.bind("<Alt-Down>",naechsterBefehl) 
        ## Zum Testen neuer Features 
        ##t1.bind("<Control-k>",gfclient_server_) 
        ##t1.bind("<Control-K>",gfclient_server_)     
         
        self.midfr = Frame(self.t,relief=RIDGE,background="white") 
        self.midfr.pack(side=TOP,fill=BOTH,expand=0) 
 
 
 
        self.butt2=Button(self.midfr,text=settings.get('DBopen'),command=self.dbopen) 
        self.butt2.pack(side=LEFT,fill=BOTH,expand=1) 


        self.butt6=Button(self.midfr,text=settings.get('Tabelle'),command=self.zeigen) 
        self.butt6.pack(side=LEFT,fill=BOTH,expand=1) 

 
        self.butt5=Button(self.midfr,text=settings.get('DBclose'),command=self.dbclose) 
        self.butt5.pack(side=LEFT,fill=BOTH,expand=1) 
 
 
        self.butt3=Button(self.midfr,text=settings.get('sitzung_open'), command=self.openfile) 
        self.butt3.pack(side=LEFT,fill=BOTH,expand=1) 


        self.butt1=Button(self.midfr,text="<==",command=voriger_Befehl) 
        self.butt1.pack(side=LEFT,fill=BOTH,expand=1) 

        self.butt4=Button(self.midfr,text=settings.get('query'),command=gfmain) 
        self.butt4.pack(side=LEFT,fill=BOTH,expand=1) 

        self.butt8=Button(self.midfr,text="pp",command=tabelle_Zeigen) 
        self.butt8.pack(side=LEFT,fill=BOTH,expand=1) 


        self.butt9=Button(self.midfr,text="NEXT",state=DISABLED,fg="red",command=self.Control_Handler)
        #self.butt9.config(state=NORMAL)
        #self.butt9.config(state=DISABLED)
        #self.butt9.update_idletasks() 
        self.butt9.pack(side=LEFT,fill=BOTH,expand=1) 


        self.butt7=Button(self.midfr,text="==>",command=naechster_Befehl) 
        self.butt7.pack(side=RIGHT,fill=BOTH,expand=1) 



 
        self.flower = Frame(self.t,width=640) 
        self.flower.pack(expand=1, fill=BOTH) 

        self.lower_menu = Menu(self.flower,tearoff=0) 

        self.lower_menu.add_command(label=settings.get('sitzung_open'), command=self.openfile)
        self.lower_menu.add_separator()
        self.lower_menu.add_command(label=settings.get('clear_unten'), command=self.cl_unten) 
        self.lower_menu.add_separator()         
        self.lower_menu.add_command(label=settings.get('tk_cut'), command=(lambda arg='t2',s=self: s.gf_cut(arg) )  ) 
        self.lower_menu.add_command(label=settings.get('tk_copy'), command=(lambda arg='t2',s=self: s.gf_copy(arg) )  ) 
        self.lower_menu.add_command(label=settings.get('tk_paste'), command=(lambda arg='t2',s=self: s.gf_paste(arg) )  ) 


 
        ##self.fupper.bind("<F1>",self.hilfe_) 
        ##self.flower.bind("<F1>",self.hilfe_) 
        self.t.bind("<F1>",self.hilfe_)
        self.t.bind("<Alt-U>",debug_mode)
        self.t.bind("<Alt-u>",debug_mode)
        
##        if os.name == 'posix': 
##            t2 = tkScrolledText.tkScrolledText(self.flower,width=70,height=16,relief=RAISED,font=gf_font,bd=2,background="white", padx=5, wrap='none') 
##        else: 
##            t2 = tkScrolledText.tkScrolledText(self.flower,width=70,height=16,relief=RAISED,font="systemfixed",bd=2,background="white", padx=5, wrap='none')
        t2 = tkScrolledText.tkScrolledText(self.flower,width=70,height=16,relief=RAISED,font=gf_font,bd=2,background="white", padx=5, wrap='none') 
        t2.pack(fill=BOTH, expand=YES)

        t2.bind("<Button-3>",self.popup2)
        
        if gfsql_debug: ## Test-Modus
            t1.focus_set()
            
        try:    
            ##self.windows = self.t.winfo_children()
            ## alternativ:
            self.windows = self.t.children.values()
        except:
            pass      

	self.t.deiconify()  # Unhide pyMaxima
	self.t.update()     # neu
	self.t.clipboard_clear()

 
#######################################
    def dbUsed2(self,arg=None):
        ##
        ##  GEHT nicht mit Lambda . . .!!!!!!!!!!!!!!!!!!!!
        ##
        debug = 0
        if debug:
            print arg       
        tkMessageBox.showinfo('Select . . .', arg ) 

    def getNewHistoryList(self):
        """dient zum erneuten Laden der History-Liste"""
        oname = askopenfilename(filetypes=[(settings.get('history_list'), "*.ini *.INI *.Ini"),(settings.get('all_files'),"*")],initialdir=gfsql_home)
        if oname: 
            ##oname = os.path.basename(oname)
            oname = os.path.abspath(oname) 
            dbList_holen(gfUsed.DirMax,dbList_file=oname)
            self.update_dbUsedMenu()
            tkMessageBox.showinfo(settings.get('history_list'),settings.get('dblist_loaded'))
        
    def update_dbUsedMenu(self): 
        """ !!Funktioniert!! EXPERIMENTELL!!"""
        self.dbUsedMenu.delete(0,END)
        laenge = gfUsed.listLength()
        for i in range(laenge):
            argument =  gfUsed.DirListe[i]
            self.dbUsedMenu.add_command(label=argument, command=(lambda arg=argument:dbUsed(arg) ))
            
    def update_confi(self): 
        """ !!Funktioniert!! EXPERIMENTELL!!""" 
        self.butt3.config(text=settings.get('sitzung_open')) 
        self.butt3.update_idletasks() 
        self.butt6.config(text=settings.get('Tabelle')) 
        self.butt5.config(text=settings.get('DBclose')) 
        self.butt2.config(text=settings.get('DBopen')) 
        self.butt4.config(text=settings.get('query')) 
        #self.butt1.config(text=settings.get('clear_oben')) 
         
        ## Achtung: Hier beginnt der Index beginnt bei 0 (und nicht bei 1!) 
        ## UND: Separator-Zeilen zählen mit!!!!!!!!
       
        self.upper_menu.entryconfigure(0,label=settings.get('DBopen') ) 
        self.upper_menu.entryconfigure(2,label=settings.get('SQL_Datei') ) 
        self.upper_menu.entryconfigure(8,label=settings.get('tk_cut') )                         
        self.upper_menu.entryconfigure(9,label=settings.get('tk_copy') ) 
        self.upper_menu.entryconfigure(10,label=settings.get('tk_paste') )
        self.upper_menu.update_idletasks() 
 
        self.lower_menu.entryconfigure(0,label=settings.get('sitzung_open') )                         
        self.lower_menu.entryconfigure(2,label=settings.get('clear_unten') ) 
        self.lower_menu.entryconfigure(4,label=settings.get('tk_cut') )                         
        self.lower_menu.entryconfigure(5,label=settings.get('tk_copy') ) 
        self.lower_menu.entryconfigure(6,label=settings.get('tk_paste') )
        self.lower_menu.update_idletasks() 

        ## Achtung: Jetzt beginnt der Index beginnt bei 1 (und nicht bei 0!) 
        ## UND: Separator-Zeilen zählen mit!!!!!!!!         
        self.filem.entryconfigure(1,label=settings.get('sitzung_open')) 
        self.filem.entryconfigure(2,label=settings.get('sitzung_save')) 
        self.filem.entryconfigure(4,label=settings.get('SQL_Datei')) 
        self.filem.entryconfigure(6,label=settings.get('clear_oben')) 
        self.filem.entryconfigure(7,label=settings.get('clear_unten')) 
        self.filem.entryconfigure(9,label=settings.get('save_quit_menu')) 
        self.filem.entryconfigure(END,label=settings.get('End_Menu')) 
        self.filem.update_idletasks() 
 
        self.sqlm.entryconfigure(1,label=settings.get('DBopen')) 
        self.sqlm.entryconfigure(2,label=settings.get('DBclose')) 
        self.sqlm.entryconfigure(3,label=settings.get('DBnew')) 
        self.sqlm.entryconfigure(11,label=settings.get('Tabelle')) 
        self.sqlm.entryconfigure(12,label=settings.get('Table_defn')) 
        self.sqlm.entryconfigure(13,label=settings.get('One_Table_defn')) 
        self.sqlm.entryconfigure(15,label=settings.get('query')) 
        self.sqlm.entryconfigure(17,label=settings.get('query_list'))
        self.sqlm.entryconfigure(19,label=settings.get('export_db'))
        self.sqlm.entryconfigure(20,label=settings.get('dia_export'))         
        ##self.sqlm.update_idletasks()
        
        self.optm.entryconfigure(1,label=settings.get('setting'))
        self.optm.entryconfigure(3,label=settings.get('dblist_laden'))
        self.optm.entryconfigure(5,label=settings.get('init_show')) 
        self.optm.entryconfigure(6,label=settings.get('init_load')) 
        self.optm.entryconfigure(7,label=settings.get('init_store')) 


        self.helpm.entryconfigure(1,label='SQLite-Version') 
        self.helpm.entryconfigure(3,label=settings.get('Hilfe')) 
        self.helpm.entryconfigure(4,label=settings.get('Info'))
        
 
        self.bar.entryconfigure(1,label=settings.get('Datei')) 
        self.bar.entryconfigure(2,label=settings.get('Datenbank')) 
        self.bar.entryconfigure(3,label=settings.get('Einstellungen')) 
        self.bar.entryconfigure(4,label=settings.get('Hilfe')) 
 
 
 
#######################################       
    def start(self): 
        global dateiname, t1, t2, gfHistory 
        line = '\ngfplus ' + __version__ + settings.get('gfplus_interaktiv') + '\n' # 
        line = line + time.strftime("%A %B %d, %Y %I:%M %p",time.localtime(time.time())) + '\n' 
        line = line + settings.get('use') 
        if dateiname != '': 
            line = line + dateiname + '"\n\n'
        ## NEU!
        if CLEARWindow:
            gfHistory.resetList()  ## NEW
            t2.delete(1.0, END)                 
            t1.delete(1.0, END)            
        t1.insert(END,line) 
        if dateiname != '': 
            t1.insert(END,prompt1) 
            t1.yview(END) 
            self.t.title(pgname + ': ' + dateiname) 
            t1.focus_set() 

    def clear_query_list(self):
        gfHistory.resetList()

    def sqlite_version(self):
        """gibt die SQlite/pysqlite-Version aus"""
        text = "SQLite-Version: "  + self._sqlite_ver_
        text = text + "\npysqlite-Version: "  + self._pysqlite_ver_
        tkMessageBox.showinfo("SQLite-Version",text)
        

    def about(self):
        global about_win_open        
        aboutText = "gfsqlite\nbased upon gfsql (by Walter Spiegel)\nURL: http://" + gfsql_url 
        aboutText = aboutText + "\nVers. " + pgversion + ", " + pgdate        
        
        aboutText = aboutText + "\n\nCredits:\nD. Richard Hipp (for sqlite)"
        aboutText = aboutText + "\nG. Häring (for pysqlite)"
        aboutText = aboutText + "\nJeff Berliner (for gfplus)"
        aboutText = aboutText + "\nGuido van Rossum (for the syntax-highcoloring from IDLE)"
        if not about_win_open:   # no about-Window 
            myTitle = "Info"
            myButton = settings.get('Close_help_window')
            about_win_open = 1
            textfenster = tkSimpleText.Text(root,title=myTitle, button_message=myButton, TEXT=aboutText,x_dim = 40, y_dim = 11,state=DISABLED )
            about_win_open = 0
 

    def hilfe(self):
        global help_win_open
        if not help_win_open:   # no Help-Window 
            myTitle = settings.get('gfsql_help')
            myButton = settings.get('Close_help_window')
            oname = gfsql_home + settings.get('help_file')
            hilfetext = gfsql_methods.datei_lesen( oname )                        
            if hilfetext != '':
                help_win_open = 1
                textfenster = tkSimpleText.Text(root,title=myTitle, button_message=myButton, TEXT=hilfetext,x_dim = 80, y_dim = 33 )
                help_win_open = 0
            else:
                fehler(oname)
            
    def hilfe_(self,event):
        self.hilfe()

####################################### 
        
    def EscapeHandler(self,event):        
        self._ende_.set(1)
        self._weiter_.set(1) # wichtig, da auf die Veränderung der Variable gewartet wird!!!
        self.butt9.config(state=DISABLED)
        self.butt9.update_idletasks()         

    def ControlHandler(self,event):              
        self._weiter_.set(1)

    def Control_Handler(self):              
        self._weiter_.set(1)
    
####################################### 
    def confi_wechseln(self): 
        """ !!Funktioniert!! EXPERIMENTELL!!""" 
        global confi 
        debug = 0 
        if confi == 'deutsch': 
            self.wechsel() 
        else: # confi == 'english'    ! 
            self.wechsel2() 
####################################### 
    def wechsel(self): 
        """ !!Funktioniert!! EXPERIMENTELL!!""" 
        global settings,confi 
        confi = 'english' 
        settings = gfsqlite_cfg.english_settings 
        self.update_confi() 
 
    def wechsel2(self): 
        """ !!Funktioniert!! EXPERIMENTELL!!""" 
        global settings,confi 
        confi = 'deutsch' 
        settings = gfsqlite_cfg.german_settings 
        self.update_confi() 
####################################### 
    def popup(self, event): 
        self.upper_menu.post(event.x_root, event.y_root)
        
    def popup2(self, event): 
        self.lower_menu.post(event.x_root, event.y_root) 
         
####################################### 
    def cl_oben(self): 
        global t1
        t1.delete(1.0, END) 
        if dboffen and dateiname != '': 
            line = settings.get('use') 
            line = line + dateiname + '"\n\n' 
            t1.insert(END,line) 
            t1.insert(END,prompt1) 
            t1.yview(END)
            
 
    def cl_(self,event):
        self.cl_oben()

 
    def cl_unten(self): 
        global t2 
        t2.delete(1.0, END) 
        t1.yview(END)
#######################################
##      mark, copy and paste
##      with widget.clipboard_append/
##      clipboard_clear/selection_get(selection="CLIPBOARD")
##      see: von Löwis/Fischbeck: Python 2, S. 339-341
##	or M. Lutz: Programming Python, S. 382-385            
    def gf_copy(self,fenster): 
        global t1,t2
        if (fenster == 't1'):
            win = t1
        else:
            win = t2
        try:
            marked_text = win.get(SEL_FIRST, SEL_LAST)
            win.clipboard_clear()
            win.clipboard_append(marked_text)
        except TclError:
            pass
    
    def gf_paste(self,fenster): 
        global t1,t2
        if (fenster == 't1'):
            win = t1
        else:
            win = t2
        try:
            text = win.selection_get(selection="CLIPBOARD")
            win.insert(INSERT, text)
            set_cursor(window=fenster) 
        except TclError:
            pass
                    
    def gf_cut(self,fenster): 
        global t1,t2
        if (fenster == 't1'):
            win = t1
        else:
            win = t2
        try:
            marked_text = win.get(SEL_FIRST, SEL_LAST)
            win.delete(SEL_FIRST, SEL_LAST)
            win.clipboard_clear()
            win.clipboard_append(marked_text)
        except TclError:
            pass
####################################### 
    def einstellungen_anzeigen(self): 
        """Einstellungen anzeigen """
        global ini_dici, einstellungen_lan, einstellungen_test, einstellungen_clear_window, einstellungen_stepbystep, TESTConnection, CLEARWindow, StepByStep
        from string import lower
        language_ = ini_dici['sprache'] 
        test_conn_ = ini_dici['test_connection']
        clear_window_ = ini_dici['clear_window']
        step_by_step_ = ini_dici['stepbystep']
        if language_ == 'locale':
            einstellungen_lan = 0
        elif language_ == 'deutsch':
            einstellungen_lan = 2
        else:   ## english
            einstellungen_lan = 1
        if test_conn_ == 'false':
            einstellungen_test = 0
        else:
            einstellungen_test = 1
            
        if clear_window_ == 'false':
            einstellungen_clear_window = 0
        else:
            einstellungen_clear_window = 1

        if step_by_step_  == 'false':
            einstellungen_stepbystep = 0
        else:
            einstellungen_stepbystep = 1
        
        
        parameter = parameterfenster3(root)
        if parameter.result <> None:
            if parameter.a1 == 0:
                ini_dici['sprache'] = 'locale'
            elif parameter.a1 == 1:
                ini_dici['sprache'] = 'english'                
            elif parameter.a1 == 2:
                ini_dici['sprache'] = 'deutsch'                
            if parameter.a3 == 0:
                ini_dici['clear_window'] = 'false'
            elif parameter.a3 == 1:
                ini_dici['clear_window'] = 'true'
            if parameter.a4 == 0:
                ini_dici['stepbystep'] = 'false'
            elif parameter.a4 == 1:
                ini_dici['stepbystep'] = 'true'                    
                
            ## Veränderte Einstellungen übernehmen
            if clear_window_ != ini_dici['clear_window']:                
                CLEARWindow = parameter.a3                
            if step_by_step_ != ini_dici['stepbystep']:                
                StepByStep = parameter.a4
                
            ## Veränderte Einstellungen sichern    
            if (ini_dici['sprache'] != language_) or (clear_window_ != ini_dici['clear_window']) or (step_by_step_  != ini_dici['stepbystep']):     
                antwort = tkMessageBox.askyesno(settings.get('save'),settings.get('save_confi'))
                if antwort:
                    self.einstellungen_speichern(meldung=0)        
                    
            

    def einstellungen_laden(self): 
        """Einstellungen laden"""
        language_ = confi
        if einstellungen_holen():
            if (language_ != confi):   ## Vorsicht!
                if language_ == 'deutsch':
                    self.wechsel()
                else: # language_ == 'english'    !
                    self.wechsel2()
            tkMessageBox.showinfo(settings.get('confi'), settings.get('confi_load') )                                 
        

    def einstellungen_speichern(self,meldung=1):
        """Einstellungen speichern"""        
        global ini_dici
        einstellungen_schreiben(info=meldung)
####################################### 
    def export_db(self):
        """Export der Datenbank, to do: Umlaute-Filter in gfsql_inter.py"""
        global pfad         
        if not dboffen: 
            tkMessageBox.showerror(settings.get('error'),settings.get('sorry_db') ) 
        else:
            dump_result = gfInter.gf_dump()            
            if len(dump_result) > 0:                
                sname = asksaveasfilename(filetypes=[(settings.get('text'), "*.txt"),(settings.get('all_files'),"*")],initialdir=pfad) 
                if sname:
                    if not gfsql_methods.test_extension(sname,".txt"):
                        sname = sname + ".txt"                    
                    try:
                        ofp = open(sname,"w")
                        ofp.write( dump_result ) 
                        ofp.flush() 
                        ofp.close()
                        ausgabe( settings.get('Datenbank') + ' ' + dateiname + settings.get('db_exported') + '\n' + sname )
                    except:    
                        ausgabe( settings.get('export_error') )
                else:
                    ausgabe( settings.get('export_aborted') )                    
            else:
                ausgabe( settings.get('export_error') )
            #self.t.after_cancel(idnr)
        

    def dia_export(self):
        """Export der Datenbank-Definition"""
        global pfad         
        if not dboffen: 
            tkMessageBox.showerror(settings.get('error'),settings.get('sorry_db') ) 
        else:
            tables = gfInter.gftable_diadefn( SERVER,settings.get('table') )
            if len(tables) > 0:
                sname = asksaveasfilename(filetypes=[(settings.get('text'), "*.txt"),(settings.get('all_files'),"*")],initialdir=pfad) 
                if sname:
                    if not gfsql_methods.test_extension(sname,".txt"):
                        sname = sname + ".txt"                    
                    try:
                        ofp = open(sname,"w")
                        ofp.write( tables ) 
                        ofp.flush() 
                        ofp.close()
                        ausgabe( settings.get('Datenbank') + settings.get('definition') + settings.get('db_exported') + '\n' + sname )

                    except:    
                        ausgabe( settings.get('export_error') )
                else:
                    ausgabe( settings.get('export_aborted') )                    
            else:
                ausgabe( settings.get('export_error') )
            #self.t.after_cancel(idnr)

#######################################         
    def zeigen(self): 
        """Zeigt Tabellen der geöffneten Datenbank an""" 
        global pfad, tab_win_open
        if not dboffen: 
            tkMessageBox.showerror(settings.get('error'),settings.get('sorry_db') ) 
        else:            
            if self.windows:
                if not tab_win_open:    # noch kein Tabellenfenster offen
                    tab_win_open = 1    
                    myTitle = settings.get('tables_from_db') + dateiname
                    myButton = settings.get('Close_help_window')
                    tabs = gfInter.gftable(SERVER)
                    ergebnis_liste = string.split( tabs ) ## enthält Tabellen
                    del ergebnis_liste[:2]       ## Kopf rauswerfen
                    ergebnis_liste.sort()
                    print str(ergebnis_liste)
                    if os.name == 'posix': 
                        tabfenster = gfsql_win.myScrollBox(self.t,title=myTitle, tab_list=ergebnis_liste, Cancel_button=0, x_dim = len(myTitle)+5, y_dim = len(ergebnis_liste), gfInt = gfInter, scroll_settings = settings )  ## Scrollfenster mit Tabellen
                    else:
                        tabfenster = gfsql_win.myScrollBox(self.t,title=myTitle, tab_list=ergebnis_liste, Cancel_button=0, x_dim = len(myTitle)+2, y_dim = len(ergebnis_liste), gfInt = gfInter, scroll_settings = settings )  ## Scrollfenster mit Tabellen
    ##                tabs = ''   # Ausgabe-Text vorbereiten
    ##                for element in ergebnis_liste:
    ##                    tabs = tabs + element + '\n'
    ##                tabfenster = tkSimpleText.Text(self.t,title=myTitle, button_message=myButton, TEXT=tabs, x_dim = len(myTitle)+2, y_dim = len(ergebnis_liste) )
                    tab_win_open = 0    # wichtig!
            else:
                t2.insert(END,'\n' + settings.get('tables_from_db') + dateiname ) 
                ausgabe( gfInter.gftable(SERVER) )
            
                
        
    def holeDBinfo(self):
        # Database-Info, 
        global dbinfo_win_open, dbUmfang        
        if not dboffen:
            tkMessageBox.showerror(settings.get('error'),settings.get('sorry_db') ) 
        else:                        
            tabs = gfInter.gftable(SERVER)                    
            ergebnis_liste = string.split( tabs ) ## enthält Tabellen            
            del ergebnis_liste[:2]                ## Kopf rauswerfen
            ergebnis_liste.sort()
            datensatz = 0
            anzahl_tab = len(ergebnis_liste)
            select = "SELECT * FROM "
            for tab in ergebnis_liste:
                ergebnis = gfInter.gfdefn(SERVER,tab)
                ergebnis = string.upper(ergebnis)
                if (string.find(ergebnis,"VIEW") == -1): # VIEWs don't count
                    qs = select + tab
                    exec_result = gfInter.exec_command(qs)
                    f = gfInter.exec_fetchall()
                    datensatz = datensatz + len(f)
                else: # VIEW!
                    anzahl_tab = anzahl_tab - 1
            umfang = 0    
            from os.path import getsize
            umfang = getsize(pfad + os.sep + dateiname)
            umfang = umfang / 1024
            dbUmfang = umfang # und global merken . . .
            temp_list = []
            temp_list.append( settings.get('dbinfo_statistik') )
            temp_list.append( dateiname )
            temp_list.append( "\n" )
            temp_list.append( settings.get('dbinfo_insgesamt') )
            temp_list.append( str(datensatz) )
            temp_list.append( settings.get('dbinfo_datensatz') )
            temp_list.append( str(anzahl_tab) )
            temp_list.append( settings.get('dbinfo_tab') )
            temp_list.append( settings.get('dbinfo_speicher') )            
            temp_list.append( str(umfang) )
            temp_list.append( " KB\n" )
            ausgabe = ''.join(temp_list)            
##            ausgabe = settings.get('dbinfo_statistik') + dateiname + "\n"
##            ausgabe = ausgabe + settings.get('dbinfo_insgesamt') + str(datensatz) + settings.get('dbinfo_datensatz')
##            ausgabe = ausgabe + str(anzahl_tab) + settings.get('dbinfo_tab')
##            ausgabe = ausgabe + settings.get('dbinfo_speicher') + str(umfang) + " KB\n"
            if not dbinfo_win_open:   # no dbinfo-Window 
                myTitle = "DB-Info: " + dateiname
                myButton = settings.get('Close_help_window')
                dbinfo_win_open = 1
                textfenster = tkSimpleText.Text(root,title=myTitle, button_message=myButton, TEXT=ausgabe,x_dim = 45, y_dim = 5,state=DISABLED )
                dbinfo_win_open = 0

            #tkMessageBox.showinfo("DB-Info: " + dateiname,  ausgabe ) 
            
 
    def defn_zeigen(self): 
        """Zeigt Datenstruktur aller Tabellen einer Datenbank an""" 
        global pfad 
        if not dboffen: 
            tkMessageBox.showerror(settings.get('error'),settings.get('sorry_db') ) 
        else: 
            t2.insert(END,'\n' + settings.get('defn_tables_from_db') + dateiname ) 
            ausgabe( gfInter.gftable_defn( SERVER,settings.get('table') )  )
            
 
    def table_zeigen(self): 
        """Zeigt Datenstruktur einer Tabelle der Datenbank an""" 
        global pfad 
        if not dboffen: 
            tkMessageBox.showerror(settings.get('error'),settings.get('sorry_db') ) 
        else: 
            gfdefn()

 
    def schliessen(self): 
        global dboffen, dateiname
        if tkMessageBox.askyesno(settings.get('End_Menu') + '?',settings.get('exit_gfsqlite') ):        
            if dboffen:
                self._ende_.set(1)
                self._weiter_.set(1)                
                if ( not gfInter.gfexit(dboffen) ):
                    tkMessageBox.showerror(settings.get('error'), settings.get('db_') + dateiname + settings.get('write_protected'))
                else:    
                    print settings.get('save_db_end') + dateiname + settings.get('closed') 
                    dboffen = 0 
                    dateiname = '' 
            die() 
 
    def beenden(self): 
        global dboffen, dateiname
        if tkMessageBox.askyesno(settings.get('End_Menu') + '?',settings.get('exit_gfsqlite') ):
            if dboffen:
                self._ende_.set(1)
                self._weiter_.set(1)                
                if databaseChanged:                
                    speichern = tkMessageBox.askyesno(settings.get('Datenbank') + ': ' + dateiname,settings.get('db_has_changed') )
                    if speichern:   
                        gfcommit()      # Datenbank im aktuellen Zustand sichern!!
                    ##else:
                    ##    gfrollback()    # Datenbank auf den letzten Zustand zuruecksetzen!!
                        
                if ( not gfInter.gfquit(dboffen) ):
                    tkMessageBox.showerror(settings.get('error'), settings.get('db_') + dateiname + settings.get('write_protected'))
                else:    
                    print settings.get('db_') + dateiname + settings.get('closed') 
                    dboffen = 0 
            die() 
 
 
    def openfile(self): 
        global t2,pfad 
        debug = 0 
        oname = askopenfilename(filetypes=[(settings.get('sql_query'), "*.txt *.TXT *.Txt"),(settings.get('all_files'),"*")],initialdir=pfad) 
        if oname: 
            oname = os.path.abspath(oname) 
            if debug: 
                print oname 
            for line in fileinput.input(oname): 
                t2.insert(END,line) 
            t2.yview(END) 
            t1.focus_set() 
            set_cursor()
 
 
    def openSQLfile(self): 
        global t2,pfad, StepByStep 
        debug = 0
        self._ende_.set(1)  # wichtig
        self._weiter_.set(1)                
        if not dboffen: 
            tkMessageBox.showerror(settings.get('error'),settings.get('sorry_db') ) 
        else: 
            oname = askopenfilename(filetypes=[(settings.get('sql_query'), "*.txt *.TXT *.Txt"),(settings.get('all_files'),"*")],initialdir=pfad) 
            if oname: 
                oname = os.path.abspath(oname) 
                if debug: 
                    print oname 
                daten = string.strip( gfsql_methods.datei_lesen(oname) )
                #print daten
                if daten <> '': 
                    if gfsql_methods.sitzungTest(daten): 
                        liste = gfsql_methods.stripSitzungDatei(daten)
                    else: # keine Sitzungs-Datei 
                        liste = gfsql_methods.stripDatei(daten)
                    # ausgeben/abarbeiten
                    self._weiter_.set(1)
                    self._ende_.set(0)
                    #StepByStep = 1 # Vorsicht! globale Var!
                    anzahl = len(liste)
                    index = 0
                    self.butt9.config(state=NORMAL)
                    self.butt9.update_idletasks() 
                    #for element in liste:   # muss hier angepasst werden!
                    while (index < anzahl) and dboffen:    
                        if StepByStep and (not self._weiter_.get() ):                                                       
                            self.t.wait_variable(self._weiter_) # Warten auf Strg/Control-Left!
                        if StepByStep and self._ende_.get():
                            # info-Fenster!!
                            #tkMessageBox.showinfo(settings.get('SQL_file'),settings.get('dblist_aborted'))
                            break   # Escape-Taste gedrückt => beenden
                        if StepByStep and self._weiter_.get():                            
                            bearbeiteBefehl(liste[index])
                            self._weiter_.set(0)                            
                        if not StepByStep:
                            bearbeiteBefehl(liste[index])
                        index = index + 1
                    self.butt9.config(state=DISABLED)
                    self.butt9.update_idletasks()                         
                else:
                    fehler(oname)

 
    def dbcreate(self): 
        """holt dateiname und pfad zur DB""" 
        global pfad,dateiname, dboffen, databaseChanged, gfUsed
        if self.dbclose(frage=1):  ## falls eine Datenbank geöffnet ist, schliessen!
            oname = asksaveasfilename(filetypes=[("sqlite DB","*.db"),(settings.get('all_files'),"*")],initialdir=pfad)            
            if oname: ## dateiname und pfad extrahieren!
                
                pfad = os.path.abspath(os.path.dirname(oname)) + os.sep
                ##pfad = os.path.dirname(oname) + os.sep 
                ##dateiname = os.path.splitext(os.path.basename(oname))[0]
                dateiname = os.path.basename(oname)
                if not gfsql_methods.test_extension(dateiname,".db"):
                    dateiname = dateiname + ".db"                
                if dateiname:
                    if os.path.exists(pfad+dateiname):
                        try:
                            os.remove(pfad+dateiname)
                            #tkMessageBox.showinfo(settings.get('db_') + dateiname +  '" ',"DB deleted!!!")
                        except:
                            pass                        

                    if gfInter.gfcreate(dateiname,pfad): 
                       dboffen = 1
                       databaseChanged = 0
                       feedback = settings.get('db_') + dateiname + settings.get('erstellt_pfad') + pfad + ')'
                       gfUsed.addEntry(pfad+dateiname)
                       self.update_dbUsedMenu()
                       set_globals_dir()
                       tkMessageBox.showinfo(settings.get('db_') + dateiname +  '" ',feedback) 
                       self.start()                       
                    else:
                        dateiname = '' 
                        tkMessageBox.showerror(' >>>FEHLER<<<','Fehler beim Erstellen der Datenbank '+ dateiname+ '!') 
                        set_globals_dir()
            else: 
                dateiname = '' 
                set_globals_dir()
 
 
 

    def dbopen(self): 
        """holt DB-Name""" 
        global t1,pfad, dateiname,dboffen, databaseChanged, gfUsed 
        _debug_ = gfsql_debug
        if self.dbclose(frage=1):  ## falls eine Datenbank geöffnet ist, schliessen! 
            oname = askopenfilename(filetypes=[("sqlite DB","*.db"),(settings.get('all_files'),"*")],initialdir=pfad)
            if oname: 
                pfad = os.path.abspath(os.path.dirname(oname)) + os.sep
                ##pfad = os.path.dirname(oname) + os.sep 
                ##dateiname = os.path.splitext(os.path.basename(oname))[0]
                dateiname = os.path.basename(oname)
                if _debug_: 
                    ausgabe('oname: ' + oname + '\nPfad: ' + pfad + ', Dateiname: ' + dateiname )
                if dateiname <> '':
                    if is_sqlite_db(oname):
                        if gfInter.gfinit(dateiname,pfad):
                            if gfInter.gftest():
                                print settings.get('path') + ': ' + pfad + ', '+ settings.get('Datenbank') + ': ' + dateiname + '\n'
                                self.start() 
                                dboffen = 1
                                databaseChanged = 0
                                gfUsed.addEntry(pfad+dateiname)
                                gfUsed.swapFirst(pfad+dateiname)                        
                                set_globals_dir()
                                self.update_dbUsedMenu()
                            else:   ## database is locked!             
                                feedback =  settings.get('db_locked') 
                                tkMessageBox.showerror(settings.get('error'),feedback)
                                dboffen = 0  ## ????
                                dateiname = ''  ### ?????
                                set_globals_dir()     
                        else:                
                            feedback =  settings.get('could_db') + ' ' + dateiname +  ' '  + settings.get('not_open')
                            tkMessageBox.showerror(settings.get('error'),feedback)
                            dboffen = 0  ## ????
                            dateiname = ''  ### ?????
                            set_globals_dir()
                    else:   ## file isn't a sqlite database!
                        feedback =  dateiname +  ' '  + settings.get('no_sqlite_db')
                        tkMessageBox.showerror(settings.get('error'),feedback)                        
                        dboffen = 0 
                        dateiname = '' 
                        set_globals_dir()

                else: 
                    dboffen = 0 
                    dateiname = '' 
                    set_globals_dir()
            
    
 
    def dbclose(self,frage=0): 
        """schliesst Datenbank dateiname""" 
        global t1,dateiname, dboffen, databaseChanged, SERVER, tab_win_open
        frage = 1
        ergebnis = 1
        win2 = None
        try:
            #win2 = self.t.winfo_children()  # liste der offenen Fenster
            win2 = self.t.children.values()
        except:
            win2 = 0        
        #################################        
        if dboffen and frage: 
            if SERVER: 
                ergebnis = tkMessageBox.askyesno(settings.get('gadfly_client'),settings.get('client_close_connection')) 
            else: 
                ergebnis = tkMessageBox.askyesno(settings.get('Datenbank') + ': ' + dateiname,settings.get('close_db'))
            if ergebnis and databaseChanged:                
                speichern = tkMessageBox.askyesno(settings.get('Datenbank') + ': ' + dateiname,settings.get('db_has_changed') )
                if speichern:   
                    gfcommit()      # Datenbank im aktuellen Zustand sichern!!
                else:
                    try:
                        gfrollback()    # Datenbank auf den letzten Zustand zuruecksetzen!!                
                    except:
                        pass
        if dboffen and ergebnis:
            self._ende_.set(1)
            self._weiter_.set(1)                            
            if win2:
                for element in win2:    # root.child-Liste durchgehen
                    if not element in self.windows: # neuen Eintrag gefunden
                        if tab_win_open == 1:   # Tabellen-Fenster offen?
                            title =  str(element.mytitle)  # Titel holen!
                            if ( string.find(title, dateiname) != -1):  # Tabellen-Fenster gefunden
                                element.destroy()       # und löschen
                                tab_win_open = 0        # Variable zurücksetzen!
                
            if ( not gfInter.gfexit(dboffen) ):
                tkMessageBox.showerror(settings.get('error'), settings.get('db_') + dateiname + settings.get('write_protected'))
            else:    
                if SERVER: 
                    line = '\n' + settings.get('gadfly_client') + ': ' + settings.get('client_connection_closed') + '\n' 
                    SERVER=0 
                else: 
                    line = '\n' + settings.get('db_') + dateiname + settings.get('closed') 
            # print line
            t1.insert(END,line) 
            t1.yview(END) 
            t1.focus_set() 
            self.t.title(pgname) 
            dboffen = 0 
            dateiname = ''
            set_globals_dir()
        return (ergebnis and not dboffen)  ## zeigt an, ob DB geschlossen wurde!! 
 
    def schreib_test(self, datei):
        return gfsql_methods.schreibTest(datei,pfad,settings)
 
    def savefile(self): 
        global t1, pfad 
        sname = asksaveasfilename(filetypes=[(settings.get('text'), "*.txt"),(settings.get('all_files'),"*")],initialdir=pfad) 
        if sname:
            if not gfsql_methods.test_extension(sname,".txt"):
                sname = sname + ".txt"
            ofp = open(sname,"w") 
            ofp.write(t1.get(1.0,END)) 
            ofp.flush() 
            ofp.close() 
 
    def gadfly_client(self): 
        """There is no sqlite-Server""" 
        pass         
######################################### 
def gfsqlite_main(IDLE=0,DEBUG=0):
    global pfad, root, idle, gfsql_debug, app    
    try:    # set the encoding to 'iso-8859-1'
        reload(sys)
        sys.setdefaultencoding('iso-8859-1')
        if hasattr(sys, "setdefaultencoding"):
            del sys.setdefaultencoding
    except:
        pass
    gfsql_debug = DEBUG
    idle = IDLE
    pfad = os.path.abspath (os.getcwd()) + os.sep 
    print settings.get('gfsql_path'), pfad
    if einstellungen_laden:
        einstellungen_holen()
        dbList_holen(gfUsed.DirMax)
    set_globals_dir()
    
    root = Tk()
    if os.name == 'posix': # in Linux: gtkLook!
        try:
            root.tk.eval('source {gtklook.tcl}')
            root.tk.eval('gtk_look')
        except:
            pass
    
    root.protocol('WM_DELETE_WINDOW',die_)
    root.geometry('800x600+25+25')
    app = sqleditor(root)
    
    if not idle: 
        root.mainloop() 
        root.destroy() 
######################################### 
## main 
if __name__ == "__main__":
    gfsqlite_main()
    ##gfsqlite_main(IDLE=1)
