#! /usr/bin/env python
# sqlKeyword.py: SQL Keywords
# see http://www.sqlite.org/lang_keywords.html for details
# This file is from the Python file keyword.py with some modifications
# Original:  keyword.py 
# Copyright (c) 2001, 2002, 2003 Python Software Foundation; 
# All Rights Reserved (http://www.python.org/2.2.3/license.html)
#
"""SQL-Keywords used in gfsqlite
   see http://www.sqlite.org/lang_keywords.html for details
   W. Spiegel, 
   2008-02-07
   Vers. 0.2
"""

__all__ = ["iskeyword", "kwlist"]

kwlist = [
#--start keywords--
      'ABORT',
      'ADD',
      'AFTER',
      'ALL',
      'ALTER',
      'ANALYZE',
      'AND',
      'AS',
      'ASC',
      'ATTACH',
      'AUTOINCREMENT',
      'BEFORE',
      'BEGIN',
      'BETWEEN',
      'BY',
      'CASCADE',
      'CASE',
      'CAST',
      'CHECK',
      'COLLATE',
      'COMMIT',
      'CONFLICT',
      'CONSTRAINT',
      'CREATE',
      'CROSS',
      'CURRENT_DATE',
      'CURRENT_TIME',
      'CURRENT_TIMESTAMP',
      'DATABASE',
      'DEFAULT',
      'DEFERRABLE',
      'DEFERRED',
      'DELETE',
      'DESC',
      'DETACH',
      'DISTINCT',
      'DROP',
      'EACH',
      'ELSE',
      'END',
      'ESCAPE',
      'EXCEPT',
      'EXCLUSIVE',
      'EXPLAIN',
      'FAIL',
      'FOR',
      'FOREIGN',
      'FROM',
      'FULL',
      'GLOB',
      'GROUP',
      'HAVING',
      'IF',
      'IGNORE',
      'IMMEDIATE',
      'IN',
      'INDEX',
      'INITIALLY',
      'INNER',
      'INSERT',
      'INSTEAD',
      'INTERSECT',
      'INTO',
      'IS',
      'ISNULL',
      'JOIN',
      'KEY',
      'LEFT',
      'LIKE',
      'LIMIT',
      'MATCH',
      'NATURAL',
      'NOT',
      'NOTNULL',
      'NULL',
      'OF',
      'OFFSET',
      'ON',
      'OR',
      'ORDER',
      'OUTER',
      'PLAN',
      'PRAGMA',
      'PRIMARY',
      'QUERY',
      'RAISE',
      'REFERENCES',
      'REINDEX',
      'RENAME',
      'REPLACE',
      'RESTRICT',
      'RIGHT',
      'ROLLBACK',
      'ROW',
      'SELECT',
      'SET',
      'TABLE',
      'TEMP',
      'TEMPORARY',
      'THEN',
      'TO',
      'TRANSACTION',
      'TRIGGER',
      'UNION',
      'UNIQUE',
      'UPDATE',
      'USING',
      'VACUUM',
      'VALUES',
      'VIEW',
      'VIRTUAL',
      'WHEN',
      'WHERE',
#--end keywords--
        ]

kwdict = {}
for keyword in kwlist:
    kwdict[keyword] = 1

iskeyword = kwdict.has_key

