#!/usr/local/bin/python
# -*- coding: Latin1 -*-  
#
## alternativ: -*- coding: utf-8 -*-
""" -*- coding: Latin1 -*- 
 gfsqlite_inter.py: Interface zu sqlite
 Vers. 0.20, WS, 2006-10-01
 Anpassung an Python 2.5/sqlite3
 Methode gfinit und gfcreate der Klasse Gfinter

 Vers. 0.21, WS, 2008-01-20
 neue Methode get_sqlite_version()

######################################  
 Klassenvariable: db, cur, mode_value, db_name

######################################
 To Do: ???
 Fehlerbehandlung!!!! => Idee: ueber try-except kapseln!
 funktioniert mit der Version 0.30 von pysqlite ganz gut!
 Hinweis: gfcreate funktioniert wie gfinit!       

######################################
"""

import sys
if (int(sys.version_info[1]) > 4): # ab Python-Version 2.5: benutze sqlite3
    import sqlite3 as sqlite
else:
    import sqlite           # fr Python-Version < 2.5: benutze sqlite
    
    


import string
import gfsql_methods


def get_sqlite_version():
    """ermittelt pysqlite und sqlite-Version,
       return: Liste mit drei Werten: boolesche Variable _version3_,
       _pysqlite_version_ und _sqlite_version_
    """
    _sqlite_version_ = "2.x"  # Default-Wert        
    _pysqlite_version_ = sqlite.version
    
    if int(_pysqlite_version_[0]) >= 2: # neue pysqlite-Version
        _sqlite_version_ = sqlite.sqlite_version
        if _sqlite_version_[0] == "3" :            
            _version3_ = 1
        else:  # kann eigentlich nicht sein . . .
            _version3_ = 0 
    elif int(_pysqlite_version_[0]) <= 1: # alte pysqlite-Version
        try:
            import _sqlite
            _sqlite_version_ = _sqlite.sqlite_version()
            if _sqlite_version_[0] == "3" :
                _version3_ = 1
            elif _sqlite_version_[0] == "2":
                _version3_ = 0
        except: # sqlite-Version nicht festgestellt!
            _version3_ = 0        

    else: # _pysqlite_version_ nicht festgestellt
        _version3_ = 0
        
    # ret-Liste aufbauen
    ret = []
    ret.append(_version3_)
    ret.append(_pysqlite_version_)
    ret.append(_sqlite_version_)
    return ret


## pp() function by Aaron Watters, posted to gadfly-rdbms@egroups.com 1/18/99 
## Thanks Aaron!!
def pp(cursor): 
    try: 
        rows = cursor.fetchall()    ## changed: list(  . . . )
    except: 
        return "No description"        
    desc = cursor.description
    names = [] 
    maxen = [] 
    for d in desc: 
        n = d[0] 
        names.append(n) 
        maxen.append(len(n))        
    rcols = range(len(desc)) 
    rrows = range(len(rows))
    for i in rrows: 
        rows[i] = rowsi = map(str, rows[i]) 
        for j in rcols: 
            maxen[j] = max(maxen[j], len(rowsi[j])) 
    for i in rcols: 
        maxcol = maxen[i] 
        name = names[i] 
        names[i] = name + (" " * (maxcol-len(name))) 
        for j in rrows: 
            val = rows[j][i] 
            rows[j][i] = val + (" " * (maxcol-len(val))) 
    from string import join 
    for j in rrows: 
        rows[j] = join(rows[j], " | ") 
    names = join(names, " | ") 
    from operator import add 
    width = reduce(add, maxen) + 3*len(desc) 
    rows.insert(0, "=" * width) 
    rows.insert(0, names) 
    return join(rows, "\n")

def pp_(cursor):
    return simple_pp(cursor)
    
def simple_pp(cursor):
    """"Very simple pretty print"""
    try: 
        rows = cursor.fetchall() 
    except: 
        return "No description"
    ergebnis = ''
    for erg in rows:
        ergebnis = ergebnis + str(erg) + '\n'
    return ergebnis    
        


class Gfinter:  ## gfinter: gfinterface
    def __init__(self):
        self.db = None 
        self.cur = None 
        self.mode_value=077
        self.db_name=''


        
    def gfinit(self,dateiname,pfad,mode_wert=077): 
        """IN: dateiname,mode_wert; OUT: db, cur, db_name, mode_value; initialisert db & setzt Cursot cur""" 
        try: 
            self.db = sqlite.connect(pfad+dateiname)
            self.mode_value=mode_wert
            self.db_name=dateiname
        except:
            return 0
        else:
            self.cur = self.db.cursor()
            self.db.text_factory = str # geht schief: sqlite.OptimizedUnicode
            return 1 

    def reinit(self): 
        """initialisert db & setzt Cursot cur NEU!"""
        pass
##        try: 
##            self.db = sqlite.connect(db=self.db_name,mode=self.mode_value)
##        except:
##            return 0
##        else:
##            self.cur = self.db.cursor() 
##            return 1 
               
###############################
        
    def gfclient_server_mode(self,user_,passwd_,database_,host_, test_connection = 0):     
        """There is no Server-Mode in sqlite!"""
        pass 
############################### 


 
    def gfcreate(self,dateiname,pfad,mode_wert=077): 
        """IN: dateiname,mode_wert; OUT: db, cur, db_name, mode_value; analog zu gfinit"""        
        try: 
            self.db = sqlite.connect(pfad+dateiname)
            self.mode_value=mode_wert
            self.db_name=dateiname
        except:
            return 0
        else:
            self.cur = self.db.cursor()
            self.db.text_factory = str # geht schief: sqlite.OptimizedUnicode
            return 1 

            
    def gfexit(self,dboffen): 
        """exit database db, commiting changes""" 
        try:
            self.db.commit()
            self.db.close()
            return 1
        except:
            self.gfrollback(dboffen)
            return 0 
 
    def gfquit(self,dboffen): 
        """exit database db, without commiting changes""" 
        try:
            self.db.close()
            return 1
        except:
            self.gfrollback(dboffen)
            return 0

 
    def gfcommit(self,dboffen): 
        """commit database""" 
        if dboffen:
            try:
                self.db.commit()
                return 1
            except IOError:        ## kein Schreibrecht!!                
                self.gfrollback(dboffen)
                return 0
            
     
    def gfrollback(self, dboffen): 
        """rollback to last commit."""
        if dboffen:
            try:  
                self.db.rollback()
                return 1
            except:
                return 0


    def gftest(self): 
        """Database-Lock Test"""
        sql = "select * from sqlite_master"
        self.cur = self.db.cursor()
        try:            
            self.cur.execute( sql )            
            return 1
        except:
            return 0

############################### 

    def gfdesc(self,SERVER, table=None, tab='',col_str=''): 
        """List columns for table named in table"""
        _debug_ = 0
        sql = "select * from sqlite_master"
        self.cur.execute( sql )
        ergebnis = self.cur.fetchall() 
        beschreibung=''
        if len(ergebnis) > 0:
            for element in ergebnis:                
                    if (table.lower()==element[1].lower() ):
                        if element[0] != "index": 
                            ausgabe = col_str + '\n'
                            len1 = len(tab) + len(table.lower())                                          
                            for i in range(len1):
                                ausgabe = ausgabe + '='
                            ausgabe = ausgabe + '\n'
                            table_col = element[-1]
                            if element[0] != "view": ## table                             
                                pos = string.find(table_col,element[1]) + len(element[1])                    
                                table_col = string.strip(table_col[pos:])
                                table_col = table_col[1:-1]
                                col_list = string.split(table_col, ',')
                                for element in col_list:
                                    element = string.strip(element)
                                    element_list = string.split(element, ' ')
                                    ausgabe = ausgabe + str(element_list[0]) + '\n'
                                if _debug_:    
                                    ausgabe = str(table_col)
                                beschreibung = tab + table + '\n' + ausgabe
                            else: ## view
                                ## CREATE VIEW mini AS SELECT lehrernr,name FROM sar_lehrer
                                lower_table_col = string.lower(table_col)
                                pos1 = string.find(lower_table_col,"select") + len("select")
                                pos2 = string.find(lower_table_col,"from")
                                table_col = table_col[pos1:pos2]
                                col_list = string.split(table_col, ',')
                                for element in col_list:
                                    element = string.strip(element)
                                    element_list = string.split(element, ' ')
                                    ausgabe = ausgabe + str(element_list[0]) + '\n'
                                if _debug_:    
                                    ausgabe = str(table_col)                                
                                beschreibung = "View: " + table + '\n' + ausgabe
                        else:
                            beschreibung = "Index: " + element[1]
        return beschreibung
 
  
    def gftable(self,SERVER): 
        """List Tables of Database"""
        sql = "select * from sqlite_master"
        self.cur.execute( sql )
        ergebnis = self.cur.fetchall() 
        tabellen=''
        if len(ergebnis) > 0:
            ## head 
            desc = self.cur.description
            tabellen = tabellen + desc[1][0].upper() + '\n'
            tabellen = tabellen + '='* len(desc[1][0])*3 + '\n'
            ## tail
            for element in ergebnis:
                if element[0] != "index": 
                    tabellen = tabellen + element[1] + '\n'
        return tabellen        
 
    def gftable_defn(self,SERVER,tab): 
        """List defn from ALL Tables of Database"""
        sql = "select * from sqlite_master"
        self.cur.execute( sql )
        ergebnis = self.cur.fetchall() 
        tabellen=''
        if len(ergebnis) > 0:
            for element in ergebnis:
                if (element[-1] != None):   ## wichtig, falls Tabellen-Definition nicht ok
                    if element[0] == 'index':
                        tabellen = tabellen + "Index: " + element[1] + '\n' + element[-1] + '\n\n'
                    else:
                        if  element[0] == 'view':
                            tabellen = tabellen + "View: " + element[1] + '\n' + element[-1] + '\n\n'
                        else:
                            tabellen = tabellen + tab + element[1] + '\n' + element[-1] + '\n\n'
                    
                
        return tabellen
 
    def formatiere(self,tabdef):
        """
            Format the printing of the Table tabdef
        """
        from string import split,replace,strip
        tabdeflist = []
        lang = 1 # Table has more then one column
        #temp = tabdef.replace("\n"," ")
        #tabdeflist = temp.split(',')
        tabdeflist = tabdef.split(',')
        #print tabdeflist
        if (len(tabdeflist) > 1):
            tabdefstart = tabdeflist[0].split('(',1)
            temp  = tabdeflist[-1]
            tabdefend = temp[0:-1]
        else:
            tabdefstart = tabdef.split('(',1)
            temp  = tabdefstart[-1]
            tabdefend = temp[0:-1]
            lang = 0    # Table has only one column
        tabDefResult = strip(tabdefstart[0]) + ' (\n'
        if lang:
            tabDefResult = tabDefResult + '  ' + strip(tabdefstart[-1]) + ',\n'
            for j in range(1,len(tabdeflist)-1):
                tabDefResult = tabDefResult + '  ' + strip(tabdeflist[j]) + ',\n'
        tabDefResult = tabDefResult + '  ' + strip( tabdefend ) + '\n )'
            
        #print tabDefResult
        return tabDefResult
    
    def gftable_diadefn(self,SERVER,tab): 
        """List defn from ALL Tables of Database"""
        sql = "select * from sqlite_master"
        self.cur.execute( sql )
        ergebnis = self.cur.fetchall() 
        tabellen=''
        if len(ergebnis) > 0:
            tabellen='\n'
            for element in ergebnis:
                if (element[-1] != None):   ## wichtig, falls Tabellen-Definition nicht ok
                    if (element[0] != 'index'):
                        if  (element[0] != 'view'):
                            #print element
                            tab = self.formatiere( element[-1] )
                            #print tab
                            tabellen = tabellen + tab + ';\n\n'                
        return tabellen


    def gfdefn(self,SERVER,table): 
        """List defn from 'table' of database"""
        from string import replace, lstrip, upper
        sql = "select * from sqlite_master"
        self.cur.execute( sql )
        ergebnis = self.cur.fetchall() 
        beschreibung=''
        if len(ergebnis) > 0:   
            for element in ergebnis:
                if (table.lower() == element[1].lower() ):
                    beschreibung = element[-1] + '\n'
        return beschreibung

############################### 
    def gf_select(self,SERVER,anfrage=''): 
        """Execute Select Statement"""
        try:
            self.cur.execute("""%s""" % anfrage)
            ergebnis = pp( self.cur ) 	
            return ergebnis
        except:
            return ''


    def gf_dump(self): 
        """Similar to the .dump Statement in sqlite, to do: Umlaute-Filter!!
        arbeitet statt mit Strings mit Listen, s. Python in a Nutshell, S. 400
        """        
        _debug_ = 0
        SERVER = 0
        dump_result = []
        start_d = "BEGIN TRANSACTION;"
        end_d = "COMMIT;"
        dump_result.append(start_d )
        dump_result.append('\n')
        tables = self.gftable(SERVER)
        tables_list = string.split(tables) 
        tables_list = tables_list[2:]   # delete head
        if len(tables_list) > 0:
            for table in tables_list: # table
                if _debug_:
                    print table
                create_table = self.gfdefn(SERVER,table)
                create_table = create_table[:-1] # without '\n'
                dump_result.append( create_table )
                dump_result.append(';\n')
                if _debug_:
                    print create_table
                endZeichen = [' ',',',')'] # fr traceStr-Test auf Apostroph in l'ecole
                if string.find(string.lower(create_table),'view') == -1: # no views!
                    anfrage = "SELECT * from %s" % table    
                    self.cur.execute("""%s""" % anfrage)
                    data_list = self.exec_fetchall()
                    if len(data_list) > 0:  # is there some data?
                        for entry in data_list:
                            traceStr = str(entry)
                            maxLen = len(traceStr) - 1
                            entry_str = traceStr[0] # erstes Zeichen!
                            for i in range(maxLen):                                
                                vor = traceStr[i]
##                                if _debug_:
##                                    pass
##                                    if (i == 5):
##                                        print vor
##
                                if i < (maxLen-1):
                                    mitte = traceStr[i+1]
                                    nach  = traceStr[i+2] 
                                    if vor.isalpha() and (vor != 'u') and (mitte == "'") and (nach not in endZeichen):                                        
                                        # Apostroph-Test: ' belassen in l'ecole etc!
                                        entry_str = entry_str + traceStr[i+1]
                                    elif (vor == 'u') and (mitte == "'") and (nach not in endZeichen):
                                        j = len(entry_str)
                                        entry_str = entry_str[0:j-1] # wirft u aus u' heraus!
                                        #print entry_str
                                        entry_str = entry_str + string.replace(traceStr[i+1],"'",'"')
                                    elif (mitte == "'"): # Begrenzungszeichen ' in " umwandeln
                                        entry_str = entry_str + string.replace(traceStr[i+1],"'",'"')
                                    else: # normales Zeichen: nichts unternehmen
                                        entry_str = entry_str + traceStr[i+1]
                            entry_str = entry_str + traceStr[maxLen] # letztes Zeichen!
                            # einfacher, aber leider falsch  . . .
                            #entry_str = str(entry)    
                            #entry_str = string.replace(str(entry),"'",'"')  # wichtig! 'b'la' -> "b'la"
                            if _debug_:
                                print entry_str
                            #insert = "INSERT INTO %s VALUES %s" % (table, str(entry) )
                            insert = "INSERT INTO %s VALUES %s" % (table, entry_str.encode('latin-1') )
                            #insert = "INSERT INTO %s VALUES %s" % (table, entry_str )
                            #insert = "INSERT INTO %s VALUES %s" % (table, entry_str.encode("utf-8") )
                            
                            dump_result.append( gfsql_methods.umlautFilter2(insert,debug=0) )  # Umlautfilter!!!!
                            dump_result.append(';\n')
                            if _debug_:
                                print insert
                                pass
            dump_result.append( end_d )
            dump_result.append('\n')
            dump_string = ''.join(dump_result)
            return dump_string
        else:
            return '' # no tables and data . . .
        


    def exec_fetchone(self): 
        """Execute fechtall"""
        return self.cur.fetchone()


    def exec_fetchall(self): 
        """Execute fechtall"""
        return self.cur.fetchall()

    def exec_desc(self): 
        """Execute desc"""        
        names = []
        desc = self.cur.description
        for d in desc: 
            n = d[0] 
            names.append(n)
        return names
    
    def exec_command(self,command): 
        """Execute command"""
        import tkMessageBox 
        try:
            #import sys
            #print sys.getdefaultencoding()
            #tkMessageBox.showinfo(">>>Debug<<<",sys.getdefaultencoding() )
            command = str(command)
            j = len(command)
            #tkMessageBox.showinfo(">>>Debug<<<",str(command[j-1]) )
            #if (command[j-1] != ';'):
            #    command = command + ';'
            #command.encode(codec='ascii')
            #tkMessageBox.showinfo(">>>Debug<<<", command )            
            self.cur.execute("""%s""" % command )
            return 1
        except StandardError,diag:
            tkMessageBox.showinfo(">>>FEHLER<<<", command + "\n"+ str(diag) ) 
            return 0


#########################################
        
def test_create():
    import sys
    print sys.getdefaultencoding()
    SERVER=0
    dboffen = 1
    create1 = "CREATE TABLE sar_lehrer (lehrernr integer primary key,name varchar(20), vorname varchar(20), typ varchar(10),prowonr integer)"
    insert1 = "INSERT INTO sar_lehrer VALUES (1, 'Spiegel', 'Walter', 'Lehrer', 1);"
    insert2 = 'INSERT INTO sar_lehrer VALUES (2, "Hilbert", "David", "Lehrer", 2);'
    insert3 = 'INSERT INTO sar_lehrer VALUES (3, u"Noether", u"Emmy", u"Lehrer", 2);'
    insert4 = "INSERT INTO sar_lehrer VALUES (4, u'Born', u'Max', u'Schueler', 3);"
    import os, os.path
    home = os.path.abspath( os.getcwd() )  + os.sep 
    print "Test im Verzeichnis: ",
    print home
    dateiname='test2.db' 
    pfad=home
    gfInter=Gfinter()
    if gfInter.gfcreate(dateiname,pfad):
        print "Datenbank: "+pfad+dateiname
        qs = create1
        gfInter.exec_command(qs)
        print str(gfInter.gftable_diadefn(SERVER,'Tabelle') )
        qs = insert1
        gfInter.exec_command(qs)
        qs = insert2
        gfInter.exec_command(qs)
        qs = insert3
        gfInter.exec_command(qs)
        qs = insert4
        gfInter.exec_command(qs)
        
        print str( gfInter.gf_select(SERVER,anfrage='Select * from sar_lehrer') )
        gfInter.gfcommit(dboffen)
        import time
        time.sleep(1)
        gfInter.gfexit(dboffen)
        print "Fertig"
    else:
        print "MIST!"

def test():
    SERVER=0
    dboffen = 1
    import os, os.path
    home = os.path.abspath( os.getcwd() )  + os.sep 
    print "Test im Verzeichnis: ",
    print home
    dateiname='test2.db' 
    pfad=home
    gfInter=Gfinter()
    if gfInter.gfinit(dateiname,pfad):
        print "Datenbank: "+pfad+dateiname
        print str( gfInter.gf_select(SERVER,anfrage='Select * from sar_lehrer') )
        print str( gfInter.gf_dump() )
        gfInter.gfexit(dboffen)
    else:
        print "MIST!"

######################################### 
## main 
if __name__ == "__main__":
    print str( get_sqlite_version() )
    
    test_create()
    test()
